/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NativeJob
implements Job {
    public static final String PROP_COMMAND = "command";
    public static final String PROP_PARAMETERS = "parameters";
    public static final String PROP_WAIT_FOR_PROCESS = "waitForProcess";
    public static final String PROP_CONSUME_STREAMS = "consumeStreams";
    static /* synthetic */ Class class$org$quartz$jobs$NativeJob;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String command = data.getString(PROP_COMMAND);
        String parameters = data.getString(PROP_PARAMETERS);
        if (parameters == null) {
            parameters = "";
        }
        boolean wait = true;
        if (data.containsKey(PROP_WAIT_FOR_PROCESS)) {
            wait = data.getBooleanValue(PROP_WAIT_FOR_PROCESS);
        }
        boolean consumeStreams = false;
        if (data.containsKey(PROP_CONSUME_STREAMS)) {
            consumeStreams = data.getBooleanValue(PROP_CONSUME_STREAMS);
        }
        this.runNativeCommand(command, parameters, wait, consumeStreams);
    }

    private static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$jobs$NativeJob == null ? (class$org$quartz$jobs$NativeJob = NativeJob.class$("org.quartz.jobs.NativeJob")) : class$org$quartz$jobs$NativeJob));
    }

    private void runNativeCommand(String command, String parameters, boolean wait, boolean consumeStreams) throws JobExecutionException {
        String[] cmd = null;
        String[] args = new String[]{command, parameters};
        try {
            int i;
            String osName = System.getProperty("os.name");
            if (osName.equals("Windows NT")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows 95")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "command.com";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows 2003")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows 2000")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows XP")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Linux")) {
                if (cmd == null) {
                    cmd = new String[args.length];
                }
                cmd = args;
            } else {
                if (cmd == null) {
                    cmd = new String[args.length];
                }
                cmd = args;
            }
            Runtime rt = Runtime.getRuntime();
            NativeJob.getLog().info((Object)("About to run" + cmd[0] + cmd[1]));
            Process proc = rt.exec(cmd);
            StreamConsumer stdoutConsumer = new StreamConsumer(proc.getInputStream(), "stdout");
            if (consumeStreams) {
                StreamConsumer stderrConsumer = new StreamConsumer(proc.getErrorStream(), "stderr");
                stdoutConsumer.start();
                stderrConsumer.start();
            }
            if (wait) {
                proc.waitFor();
            }
        }
        catch (Exception x) {
            throw new JobExecutionException("Error launching native command: ", x, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StreamConsumer
    extends Thread {
        InputStream is;
        String type;

        public StreamConsumer(InputStream inputStream, String type) {
            this.is = inputStream;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(this.is));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (this.type.equalsIgnoreCase("stderr")) {
                    NativeJob.getLog().warn((Object)(this.type + ">" + line));
                    continue;
                }
                NativeJob.getLog().info((Object)(this.type + ">" + line));
            }
            Object var4_4 = null;
            if (br == null) return;
            try {
                br.close();
                return;
            }
            catch (Exception ignore) {}
            return;
            {
                catch (IOException ioe) {
                    NativeJob.getLog().error((Object)("Error consuming " + this.type + " stream of spawned process."), (Throwable)ioe);
                    Object var4_5 = null;
                    if (br == null) return;
                    try {
                        br.close();
                        return;
                    }
                    catch (Exception ignore) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

