/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupEventListenerHandler;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOImpl
extends BaseDAO
implements GroupHandler,
GroupEventListenerHandler {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.GroupDAOImpl");
    protected List<GroupEventListener> listeners = new ArrayList<GroupEventListener>(3);

    public GroupDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) throws Exception {
        super(ldapAttrMapping, ldapService);
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners.add(listener);
    }

    public final Group createGroupInstance() {
        return new GroupImpl();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    /*
     * Exception decompiling
     */
    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 6[CATCHBLOCK]], but top level block is 13[SIMPLE_IF_ELSE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    Group parent = this.findGroupById(ctx, group.getParentId());
                    this.setId(parent, group);
                    String groupDN = this.ldapAttrMapping.groupDNKey + "=" + group.getGroupName() + "," + this.createSubDN(parent);
                    ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
                    ModificationItem mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.ldapDescriptionAttr, group.getDescription()));
                    modifications.add(mod);
                    mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.groupLabelAttr, group.getLabel()));
                    modifications.add(mod);
                    ModificationItem[] mods = new ModificationItem[modifications.size()];
                    modifications.toArray(mods);
                    if (broadcast) {
                        this.preSave(group, true);
                    }
                    ctx.modifyAttributes(groupDN, mods);
                    if (broadcast) {
                        this.postSave(group, true);
                    }
                    return;
                }
                catch (NamingException e) {
                    if (!GroupDAOImpl.isConnectionError(e) || err >= GroupDAOImpl.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * Exception decompiling
     */
    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                ArrayList<Group> arrayList;
                block14: {
                    groups.clear();
                    try {
                        String filter = "(&(" + this.ldapAttrMapping.membershipTypeMemberValue + "=" + this.getDNFromUsername(ctx, userName) + ")(" + this.ldapAttrMapping.membershipTypeRoleNameAttr + "=" + membershipType + "))";
                        SearchControls constraints = new SearchControls();
                        constraints.setSearchScope(2);
                        results = ctx.search(this.ldapAttrMapping.groupsURL, filter, constraints);
                        while (results.hasMoreElements()) {
                            SearchResult sr = results.next();
                            NameParser parser = ctx.getNameParser("");
                            Name entryNameName = parser.parse(new CompositeName(sr.getName()).get(0));
                            String entryName = String.valueOf(entryNameName).substring(entryNameName.getSuffix(1).toString().length() + 1);
                            String groupDN = entryName + "," + this.ldapAttrMapping.groupsURL;
                            Group group = this.getGroupByDN(ctx, groupDN);
                            if (group == null) continue;
                            this.addGroup(groups, group);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Retrieved " + groups.size() + " groups from ldap for user " + userName + " with membershiptype " + membershipType));
                        }
                        arrayList = groups;
                        if (results == null) break block14;
                    }
                    catch (NamingException e) {
                        block15: {
                            try {
                                if (GroupDAOImpl.isConnectionError(e) && err < GroupDAOImpl.getMaxConnectionError()) {
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block15;
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group findGroupById(String groupId) throws Exception {
        if (groupId == null) {
            return null;
        }
        String parentId = null;
        StringBuffer buffer = new StringBuffer();
        String[] groupIdParts = groupId.split("/");
        for (int x = 1; x < groupIdParts.length; ++x) {
            buffer.append("/" + groupIdParts[x]);
            if (x != groupIdParts.length - 2) continue;
            parentId = buffer.toString();
        }
        String groupDN = this.getGroupDNFromGroupId(groupId);
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    Attributes attrs = ctx.getAttributes(groupDN);
                    Group group = this.ldapAttrMapping.attributesToGroup(attrs);
                    ((GroupImpl)group).setId(groupId);
                    ((GroupImpl)group).setParentId(parentId);
                    Group group2 = group;
                    return group2;
                }
                catch (NamingException e) {
                    try {
                        if (!GroupDAOImpl.isConnectionError(e) || err >= GroupDAOImpl.getMaxConnectionError()) {
                            throw e;
                        }
                        ctx = this.ldapService.getLdapContext(true);
                        ++err;
                        continue;
                    }
                    catch (NameNotFoundException e2) {
                        Group group = null;
                        return group;
                    }
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    private Group findGroupById(LdapContext ctx, String groupId) throws Exception {
        if (groupId == null) {
            return null;
        }
        String parentId = null;
        StringBuffer buffer = new StringBuffer();
        String[] groupIdParts = groupId.split("/");
        for (int x = 1; x < groupIdParts.length; ++x) {
            buffer.append("/" + groupIdParts[x]);
            if (x != groupIdParts.length - 2) continue;
            parentId = buffer.toString();
        }
        String groupDN = this.getGroupDNFromGroupId(groupId);
        try {
            Attributes attrs = ctx.getAttributes(groupDN);
            Group group = this.ldapAttrMapping.attributesToGroup(attrs);
            ((GroupImpl)group).setId(groupId);
            ((GroupImpl)group).setParentId(parentId);
            return group;
        }
        catch (NameNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllGroups() throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        LdapContext ctx = this.ldapService.getLdapContext();
        String groupName = "*";
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                Serializable sr;
                block20: {
                    groups.clear();
                    try {
                        results = ctx.search(this.ldapAttrMapping.groupsURL, "(" + this.ldapAttrMapping.groupNameAttr + "=" + groupName + ")", constraints);
                    }
                    catch (NamingException e1) {
                        if (GroupDAOImpl.isConnectionError(e1)) {
                            throw e1;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Failed to get all groups. ", (Throwable)e1);
                        }
                        ArrayList<Group> arrayList = groups;
                        if (results != null) {
                            results.close();
                        }
                        this.ldapService.release(ctx);
                        return arrayList;
                    }
                    try {
                        while (results.hasMoreElements()) {
                            Name entryName;
                            String groupDN;
                            Group group;
                            sr = results.next();
                            NameParser parser = ctx.getNameParser("");
                            CompositeName name = new CompositeName(((NameClassPair)sr).getName());
                            if (name.size() <= 0 || (group = this.getGroupByDN(ctx, groupDN = (entryName = parser.parse(name.get(0))) + "," + this.ldapAttrMapping.groupsURL)) == null) continue;
                            this.addGroup(groups, group);
                        }
                        sr = groups;
                        if (results == null) break block20;
                    }
                    catch (NamingException e2) {
                        block21: {
                            try {
                                if (GroupDAOImpl.isConnectionError(e2) && err < GroupDAOImpl.getMaxConnectionError()) {
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block21;
                                }
                                throw e2;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return sr;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findGroups(Group parent) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        String groupsBaseDN = this.ldapAttrMapping.groupsURL;
        StringBuffer buffer = new StringBuffer();
        if (parent != null) {
            String[] dnParts = parent.getId().split("/");
            for (int x = dnParts.length - 1; x > 0; --x) {
                buffer.append(this.ldapAttrMapping.groupDNKey + "=" + dnParts[x] + ", ");
            }
        }
        buffer.append(groupsBaseDN);
        LdapContext ctx = this.ldapService.getLdapContext();
        String searchBase = buffer.toString();
        String filter = this.ldapAttrMapping.groupObjectClassFilter;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                Serializable sr;
                block22: {
                    groups.clear();
                    try {
                        results = ctx.search(searchBase, filter, constraints);
                    }
                    catch (NamingException e1) {
                        if (GroupDAOImpl.isConnectionError(e1)) {
                            throw e1;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Failed to get groups from parent " + parent.getId() + ". "), (Throwable)e1);
                        }
                        ArrayList<Group> arrayList = groups;
                        if (results != null) {
                            results.close();
                        }
                        this.ldapService.release(ctx);
                        return arrayList;
                    }
                    try {
                        while (results.hasMoreElements()) {
                            Name entryName;
                            String groupDN;
                            Group group;
                            sr = results.next();
                            NameParser parser = ctx.getNameParser("");
                            CompositeName name = new CompositeName(((NameClassPair)sr).getName());
                            if (name.size() <= 0 || (group = this.getGroupByDN(ctx, groupDN = (entryName = parser.parse(name.get(0))) + "," + searchBase)) == null) continue;
                            this.addGroup(groups, group);
                        }
                        sr = groups;
                        if (results == null) break block22;
                    }
                    catch (NamingException e2) {
                        block23: {
                            try {
                                if (GroupDAOImpl.isConnectionError(e2) && err < GroupDAOImpl.getMaxConnectionError()) {
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block23;
                                }
                                throw e2;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return sr;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findGroupsOfUser(String userName) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                ArrayList<Group> arrayList;
                block18: {
                    String userDN;
                    NamingEnumeration<SearchResult> results;
                    block16: {
                        ArrayList<Group> arrayList2;
                        block17: {
                            groups.clear();
                            results = null;
                            userDN = this.getDNFromUsername(ctx, userName);
                            if (userDN != null) break block16;
                            arrayList2 = groups;
                            if (results == null) break block17;
                            results.close();
                        }
                        return arrayList2;
                    }
                    try {
                        userDN = userDN.trim();
                        SearchControls constraints = new SearchControls();
                        constraints.setSearchScope(2);
                        String mbfilter = this.membershipClassFilter();
                        String userFilter = "(" + this.ldapAttrMapping.membershipTypeMemberValue + "=" + userDN + ")";
                        String filter = "(&" + userFilter + mbfilter + ")";
                        results = ctx.search(this.ldapAttrMapping.groupsURL, filter, constraints);
                        while (results != null && results.hasMore()) {
                            SearchResult sr = results.next();
                            NameParser parser = ctx.getNameParser("");
                            CompositeName name = new CompositeName(sr.getName());
                            if (name.size() < 1) break;
                            Name entryName = parser.parse(name.get(0));
                            String membershipDN = entryName + "," + this.ldapAttrMapping.groupsURL;
                            Group group = this.getGroupFromMembershipDN(ctx, membershipDN);
                            if (group == null) continue;
                            this.addGroup(groups, group);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Retrieved " + groups.size() + " groups from ldap for user " + userName));
                        }
                        arrayList = groups;
                        if (results == null) break block18;
                    }
                    catch (NamingException e2) {
                        block19: {
                            try {
                                if (GroupDAOImpl.isConnectionError(e2) && err < GroupDAOImpl.getMaxConnectionError()) {
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block19;
                                }
                                throw e2;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    protected void addGroup(List<Group> groups, Group g) {
        for (int i = 0; i < groups.size(); ++i) {
            if (!groups.get(i).getId().equals(g.getId())) continue;
            return;
        }
        groups.add(g);
    }

    protected void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preSave(group, isNew);
        }
    }

    protected void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postSave(group, isNew);
        }
    }

    protected void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preDelete(group);
        }
    }

    protected void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postDelete(group);
        }
    }

    protected String createSubDN(Group parent) {
        if (parent == null) {
            return this.createSubDN("");
        }
        return this.createSubDN(parent.getId());
    }

    protected String createSubDN(String parentId) {
        StringBuffer buffer = new StringBuffer();
        if (parentId != null && parentId.length() > 0) {
            String[] dnParts = parentId.split("/");
            for (int x = dnParts.length - 1; x > 0; --x) {
                buffer.append(this.ldapAttrMapping.groupDNKey + "=" + dnParts[x] + ", ");
            }
        }
        buffer.append(this.ldapAttrMapping.groupsURL);
        return buffer.toString();
    }

    protected void setId(Group parent, Group g) {
        GroupImpl group = (GroupImpl)g;
        if (parent == null) {
            group.setId("/" + group.getGroupName());
            return;
        }
        group.setId(parent.getId() + "/" + group.getGroupName());
        group.setParentId(parent.getId());
    }

    public List<GroupEventListener> getGroupListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

