/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.TransportGuarantee;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.EventInfo;
import org.gatein.pc.api.info.EventingInfo;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.SecurityInfo;
import org.gatein.pc.api.info.WindowStateInfo;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.registration.Registration;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.ServiceDescriptionInterface;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.handlers.ServiceHandler;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.LocalizedString;
import org.oasis.wsrp.v2.MarkupType;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.ParameterDescription;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.ServiceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptionHandler
extends ServiceHandler
implements ServiceDescriptionInterface,
ManagedObjectRegistryEventListener {
    private static final CookieProtocol BEA_8_CONSUMER_FIX = CookieProtocol.PER_USER;
    private ServiceDescriptionInfo serviceDescription;

    public ServiceDescriptionHandler(WSRPProducerImpl producer) {
        super(producer);
        this.serviceDescription = new ServiceDescriptionInfo(producer);
    }

    @Override
    public ServiceDescription getServiceDescription(GetServiceDescription gs) throws InvalidRegistration, ModifyRegistrationRequired, OperationFailed, ResourceSuspended {
        boolean needsPortletDescriptions;
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)gs, (String)"GetServiceDescription");
        RegistrationContext registrationContext = gs.getRegistrationContext();
        Registration registration = null;
        if (registrationContext != null) {
            registration = this.producer.getRegistrationOrFailIfInvalid(registrationContext);
        }
        ProducerRegistrationRequirements requirements = this.producer.getProducerRegistrationRequirements();
        this.serviceDescription.updateRegistrationProperties(requirements);
        boolean needsRegistrationProperties = registration == null && requirements.isRegistrationRequired();
        boolean bl = needsPortletDescriptions = registration != null || !requirements.isRegistrationRequired() || !requirements.isRegistrationRequiredForFullDescription();
        if (needsPortletDescriptions) {
            Set<Object> portlets;
            try {
                portlets = this.producer.getRemotablePortlets();
            }
            catch (PortletInvokerException e) {
                log.warn("Could not retrieve portlets. Reason:\n\t" + e.getLocalizedMessage());
                portlets = Collections.emptySet();
            }
            this.serviceDescription.updatePortletDescriptions(portlets, gs.getDesiredLocales(), registration);
        }
        return this.serviceDescription.getServiceDescription(needsRegistrationProperties, needsPortletDescriptions, gs.getPortletHandles());
    }

    public PortletDescription getPortletDescription(PortletContext portletContext, List<String> desiredLocales, Registration registration) throws InvalidHandle, OperationFailed {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        try {
            Portlet portlet = this.producer.getPortletWith(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext), registration);
            return ServiceDescriptionHandler.getPortletDescription(portlet, desiredLocales);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Could not retrieve portlet '" + portletContext + "'"), (Throwable)e);
        }
    }

    public static PortletDescription getPortletDescription(Portlet portlet, List<String> desiredLocales) {
        return ServiceDescriptionHandler.getPortletDescription(portlet, desiredLocales, null);
    }

    static PortletDescription getPortletDescription(Portlet portlet, List<String> desiredLocales, ServiceDescriptionInfo sdi) {
        return ServiceDescriptionHandler.getPortletDescription(portlet.getContext(), portlet.getInfo(), desiredLocales, sdi);
    }

    private static PortletDescription getPortletDescription(org.gatein.pc.api.PortletContext context, PortletInfo info, List<String> desiredLocales, ServiceDescriptionInfo sdi) {
        SecurityInfo secInfo;
        Collection parameterInfos;
        NavigationInfo navigationInfo;
        EventingInfo eventsInfo;
        String commaSeparatedKeywords;
        String handle = context.getId();
        if (log.isDebugEnabled()) {
            log.debug("Constructing portlet description for: " + handle);
        }
        CapabilitiesInfo capInfo = info.getCapabilities();
        Set allMediaTypes = capInfo.getMediaTypes();
        ArrayList<MarkupType> markupTypes = new ArrayList<MarkupType>(allMediaTypes.size());
        for (MediaType mediaType : allMediaTypes) {
            MarkupType markupType = WSRPTypeFactory.createMarkupType((String)mediaType.getValue(), ServiceDescriptionHandler.getModeNamesFrom(capInfo.getModes(mediaType)), ServiceDescriptionHandler.getWindowStateNamesFrom(capInfo.getWindowStates(mediaType)), ServiceDescriptionHandler.getLocaleNamesFrom(capInfo.getLocales(mediaType)));
            markupTypes.add(markupType);
        }
        PortletDescription desc = WSRPTypeFactory.createPortletDescription((String)handle, markupTypes);
        desc.setGroupID(info.getApplicationName());
        MetaInfo metaInfo = info.getMeta();
        desc.setDescription(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("description"), desiredLocales));
        desc.setShortTitle(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("short-title"), desiredLocales));
        desc.setTitle(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("title"), desiredLocales));
        desc.setDisplayName(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("display-name"), desiredLocales));
        LocalizedString concatenatedKeywords = Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("keywords"), desiredLocales);
        if (concatenatedKeywords != null && (commaSeparatedKeywords = concatenatedKeywords.getValue()) != null && commaSeparatedKeywords.length() > 0) {
            String[] keywordArray;
            String lang = concatenatedKeywords.getLang();
            for (String keyword : keywordArray = commaSeparatedKeywords.split(",")) {
                desc.getKeywords().add(WSRPTypeFactory.createLocalizedString((String)lang, (String)concatenatedKeywords.getResourceName(), (String)keyword.trim()));
            }
        }
        if ((eventsInfo = info.getEventing()) != null) {
            Map consumedEvents;
            Map producedEvents = eventsInfo.getProducedEvents();
            if (ParameterValidation.existsAndIsNotEmpty((Map)producedEvents)) {
                List publishedEvents = desc.getPublishedEvents();
                for (Map.Entry entry : producedEvents.entrySet()) {
                    publishedEvents.add(entry.getKey());
                    if (sdi == null) continue;
                    sdi.addEventInfo((EventInfo)entry.getValue(), desiredLocales);
                }
            }
            if (ParameterValidation.existsAndIsNotEmpty((Map)(consumedEvents = eventsInfo.getConsumedEvents()))) {
                List handledEvents = desc.getHandledEvents();
                for (Map.Entry entry : consumedEvents.entrySet()) {
                    handledEvents.add(entry.getKey());
                    if (sdi == null) continue;
                    sdi.addEventInfo((EventInfo)entry.getValue(), desiredLocales);
                }
            }
        }
        if ((navigationInfo = info.getNavigation()) != null && ParameterValidation.existsAndIsNotEmpty((Collection)(parameterInfos = navigationInfo.getPublicParameters()))) {
            List publicValueDescriptions = desc.getNavigationalPublicValueDescriptions();
            for (ParameterInfo parameterInfo : parameterInfos) {
                String id = parameterInfo.getId();
                ParameterDescription paramDesc = WSRPTypeFactory.createParameterDescription((String)id);
                paramDesc.setDescription(Utils.convertToWSRPLocalizedString(parameterInfo.getDescription(), desiredLocales));
                paramDesc.setLabel(WSRPTypeFactory.createLocalizedString((String)id));
                List names = paramDesc.getNames();
                names.add(parameterInfo.getName());
                Collection aliases = parameterInfo.getAliases();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)aliases)) {
                    names.addAll(aliases);
                }
                publicValueDescriptions.add(paramDesc);
            }
        }
        if ((secInfo = info.getSecurity()).containsTransportGuarantee(TransportGuarantee.INTEGRAL) || secInfo.containsTransportGuarantee(TransportGuarantee.CONFIDENTIAL)) {
            desc.setOnlySecure(Boolean.valueOf(true));
        }
        return desc;
    }

    public void onEvent(ManagedObjectRegistryEvent event) {
        ManagedObjectEvent managedObjectEvent;
        ManagedObject managedObject;
        if (event instanceof ManagedObjectEvent && (managedObject = (managedObjectEvent = (ManagedObjectEvent)event).getManagedObject()) instanceof ManagedPortletContainer) {
            ManagedObjectLifeCycleEvent lifeCycleEvent;
            LifeCycleStatus status;
            ManagedPortletContainer portletContainer = (ManagedPortletContainer)managedObject;
            String applicationId = portletContainer.getManagedPortletApplication().getId();
            String containerId = portletContainer.getId();
            if (!(managedObjectEvent instanceof ManagedObjectLifeCycleEvent) || LifeCycleStatus.STARTED.equals((Object)(status = (lifeCycleEvent = (ManagedObjectLifeCycleEvent)managedObjectEvent).getStatus()))) {
                // empty if block
            }
        }
    }

    private static List<String> getLocaleNamesFrom(Collection<Locale> locales) {
        if (locales == null || locales.isEmpty()) {
            return null;
        }
        ArrayList<String> localeNames = new ArrayList<String>(locales.size());
        for (Locale locale : locales) {
            localeNames.add(WSRPUtils.toString((Locale)locale));
        }
        return localeNames;
    }

    private static List<String> getWindowStateNamesFrom(Collection<WindowStateInfo> windowStates) {
        ArrayList<String> result = new ArrayList<String>(windowStates.size());
        for (WindowStateInfo windowStateInfo : windowStates) {
            result.add(WSRPUtils.convertJSR168WindowStateNameToWSRPName((String)windowStateInfo.getWindowStateName()));
        }
        return result;
    }

    private static List<String> getModeNamesFrom(Collection<ModeInfo> modes) {
        ArrayList<String> result = new ArrayList<String>(modes.size());
        for (ModeInfo modeInfo : modes) {
            result.add(WSRPUtils.convertJSR168PortletModeNameToWSRPName((String)modeInfo.getModeName()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceDescriptionInfo {
        private ServiceDescription noRegistrationNoPortletsServiceDescription = WSRPTypeFactory.createServiceDescription((boolean)false);
        private ServiceDescription noRegistrationPortletsServiceDescription;
        private ServiceDescription registrationNoPortletsServiceDescription;
        private ServiceDescription registrationPortletsServiceDescription;
        private long lastGenerated;
        private Map<QName, EventDescription> eventDescriptions;
        private static final List<String> OPTIONS = new ArrayList<String>(5);

        private ServiceDescriptionInfo(WSRPProducerImpl producer) {
            this.noRegistrationNoPortletsServiceDescription.setRequiresInitCookie(BEA_8_CONSUMER_FIX);
            this.noRegistrationNoPortletsServiceDescription.getLocales().addAll(producer.getSupportedLocales());
            this.noRegistrationNoPortletsServiceDescription.getSupportedOptions().addAll(OPTIONS);
            this.noRegistrationPortletsServiceDescription = WSRPTypeFactory.createServiceDescription((boolean)false);
            this.noRegistrationPortletsServiceDescription.setRequiresInitCookie(BEA_8_CONSUMER_FIX);
            this.noRegistrationPortletsServiceDescription.getLocales().addAll(producer.getSupportedLocales());
            this.noRegistrationPortletsServiceDescription.getSupportedOptions().addAll(OPTIONS);
            this.registrationNoPortletsServiceDescription = WSRPTypeFactory.createServiceDescription((boolean)false);
            this.registrationNoPortletsServiceDescription.setRequiresInitCookie(BEA_8_CONSUMER_FIX);
            this.registrationNoPortletsServiceDescription.getLocales().addAll(producer.getSupportedLocales());
            this.registrationNoPortletsServiceDescription.getSupportedOptions().addAll(OPTIONS);
            this.registrationPortletsServiceDescription = WSRPTypeFactory.createServiceDescription((boolean)false);
            this.registrationPortletsServiceDescription.setRequiresInitCookie(BEA_8_CONSUMER_FIX);
            this.registrationPortletsServiceDescription.getLocales().addAll(producer.getSupportedLocales());
            this.registrationPortletsServiceDescription.getSupportedOptions().addAll(OPTIONS);
        }

        private void updateRegistrationProperties(ProducerRegistrationRequirements requirements) {
            long lastModified = requirements.getLastModified();
            if (lastModified > this.lastGenerated) {
                if (ServiceHandler.log.isDebugEnabled()) {
                    ServiceHandler.log.debug("Re-generating registration properties information for service description.");
                }
                Map<QName, RegistrationPropertyDescription> info = requirements.getRegistrationProperties();
                ModelDescription registrationProperties = null;
                if (ParameterValidation.existsAndIsNotEmpty(info)) {
                    registrationProperties = Utils.convertRegistrationPropertiesToModelDescription(info);
                }
                this.registrationNoPortletsServiceDescription.setRegistrationPropertyDescription(registrationProperties);
                this.registrationPortletsServiceDescription.setRegistrationPropertyDescription(registrationProperties);
                this.noRegistrationNoPortletsServiceDescription.setRequiresRegistration(requirements.isRegistrationRequired());
                this.noRegistrationPortletsServiceDescription.setRequiresRegistration(requirements.isRegistrationRequired());
                this.registrationNoPortletsServiceDescription.setRequiresRegistration(requirements.isRegistrationRequired());
                this.registrationPortletsServiceDescription.setRequiresRegistration(requirements.isRegistrationRequired());
                this.lastGenerated = System.nanoTime();
            }
        }

        private void updatePortletDescriptions(Set<Portlet> portlets, List<String> desiredLocales, Registration registration) {
            if (ParameterValidation.existsAndIsNotEmpty(portlets)) {
                ArrayList<PortletDescription> offeredPortletDescriptions = new ArrayList<PortletDescription>(portlets.size());
                this.eventDescriptions = new HashMap<QName, EventDescription>(portlets.size());
                for (Portlet portlet : portlets) {
                    PortletDescription desc = ServiceDescriptionHandler.getPortletDescription(portlet, desiredLocales, this);
                    offeredPortletDescriptions.add(desc);
                }
                Collection<EventDescription> events = this.eventDescriptions.values();
                List eventDescriptions = this.registrationPortletsServiceDescription.getEventDescriptions();
                eventDescriptions.clear();
                eventDescriptions.addAll(events);
                eventDescriptions = this.registrationNoPortletsServiceDescription.getEventDescriptions();
                eventDescriptions.clear();
                eventDescriptions.addAll(events);
                eventDescriptions = this.noRegistrationPortletsServiceDescription.getEventDescriptions();
                eventDescriptions.clear();
                eventDescriptions.addAll(events);
                eventDescriptions = this.noRegistrationNoPortletsServiceDescription.getEventDescriptions();
                eventDescriptions.clear();
                eventDescriptions.addAll(events);
                List offeredPortlets = this.registrationPortletsServiceDescription.getOfferedPortlets();
                offeredPortlets.clear();
                offeredPortlets.addAll(offeredPortletDescriptions);
                offeredPortlets = this.noRegistrationPortletsServiceDescription.getOfferedPortlets();
                offeredPortlets.clear();
                offeredPortlets.addAll(offeredPortletDescriptions);
            }
        }

        private ServiceDescription getServiceDescription(boolean needsRegistrationProperties, boolean needsPortletDescriptions, List<String> portletHandles) {
            ServiceDescription serviceDescription;
            if (needsRegistrationProperties) {
                serviceDescription = needsPortletDescriptions ? this.registrationPortletsServiceDescription : this.registrationNoPortletsServiceDescription;
            } else {
                ServiceDescription serviceDescription2 = serviceDescription = needsPortletDescriptions ? this.noRegistrationPortletsServiceDescription : this.noRegistrationNoPortletsServiceDescription;
            }
            if (ParameterValidation.existsAndIsNotEmpty(portletHandles)) {
                List offeredPortlets = serviceDescription.getOfferedPortlets();
                ArrayList<PortletDescription> filteredPortlets = new ArrayList<PortletDescription>(offeredPortlets.size());
                block0: for (String handle : portletHandles) {
                    for (PortletDescription description : offeredPortlets) {
                        if (!description.getPortletHandle().equals(handle)) continue;
                        filteredPortlets.add(description);
                        continue block0;
                    }
                }
                ServiceDescription filtered = WSRPTypeFactory.createServiceDescription((boolean)serviceDescription.isRequiresRegistration());
                filtered.setExportDescription(serviceDescription.getExportDescription());
                filtered.setMayReturnRegistrationState(serviceDescription.isMayReturnRegistrationState());
                filtered.setRegistrationPropertyDescription(serviceDescription.getRegistrationPropertyDescription());
                filtered.setRequiresInitCookie(serviceDescription.getRequiresInitCookie());
                filtered.setResourceList(serviceDescription.getResourceList());
                filtered.setSchemaType(serviceDescription.getSchemaType());
                filtered.getCustomModeDescriptions().addAll(serviceDescription.getCustomModeDescriptions());
                filtered.getCustomWindowStateDescriptions().addAll(serviceDescription.getCustomWindowStateDescriptions());
                filtered.getEventDescriptions().addAll(serviceDescription.getEventDescriptions());
                filtered.getExtensionDescriptions().addAll(serviceDescription.getExtensionDescriptions());
                filtered.getExtensions().addAll(serviceDescription.getExtensions());
                filtered.getLocales().addAll(serviceDescription.getLocales());
                filtered.getSupportedOptions().addAll(serviceDescription.getSupportedOptions());
                filtered.getOfferedPortlets().addAll(filteredPortlets);
                return filtered;
            }
            return serviceDescription;
        }

        public void addEventInfo(EventInfo info, List<String> desiredLocales) {
            QName name = info.getName();
            if (!this.eventDescriptions.containsKey(name)) {
                EventDescription desc = WSRPTypeFactory.createEventDescription((QName)name);
                desc.setDescription(Utils.convertToWSRPLocalizedString(info.getDescription(), desiredLocales));
                desc.setLabel(Utils.convertToWSRPLocalizedString(info.getDisplayName(), desiredLocales));
                Collection aliases = info.getAliases();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)aliases)) {
                    desc.getAliases().addAll(aliases);
                }
                this.eventDescriptions.put(name, desc);
            }
        }

        static {
            OPTIONS.add("wsrp:events");
            OPTIONS.add("wsrp:import");
            OPTIONS.add("wsrp:export");
        }
    }
}

