/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.util.Map;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.handlers.processors.MimeResponseProcessor;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.WSRPPortletInvocationContext;
import org.gatein.wsrp.producer.handlers.processors.WSRPRequestContext;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MimeRequest;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceContext;
import org.oasis.wsrp.v2.ResourceParams;
import org.oasis.wsrp.v2.ResourceResponse;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceRequestProcessor
extends MimeResponseProcessor<ResourceContext, ResourceResponse> {
    private final GetResource getResource;

    public ResourceRequestProcessor(ProducerHelper producer, GetResource getResource) throws InvalidRegistration, OperationFailed, MissingParameters, InvalidHandle, UnsupportedMimeType, UnsupportedWindowState, UnsupportedMode, ModifyRegistrationRequired {
        super(producer);
        this.getResource = getResource;
        this.prepareInvocation();
    }

    @Override
    public PortletContext getPortletContext() {
        return this.getResource.getPortletContext();
    }

    @Override
    AccessMode getAccessMode() throws MissingParameters {
        return AccessMode.READ_ONLY;
    }

    @Override
    String getContextName() {
        return "GetResource";
    }

    @Override
    MimeRequest getParams() {
        return this.getResource.getResourceParams();
    }

    @Override
    RegistrationContext getRegistrationContext() {
        return this.getResource.getRegistrationContext();
    }

    @Override
    RuntimeContext getRuntimeContext() {
        return this.getResource.getRuntimeContext();
    }

    @Override
    UserContext getUserContext() {
        return this.getResource.getUserContext();
    }

    @Override
    protected PortletInvocation internalInitInvocation(WSRPPortletInvocationContext context) {
        ResourceInvocation resourceInvocation = new ResourceInvocation((PortletInvocationContext)context);
        ResourceParams resourceParams = this.getResource.getResourceParams();
        String id = this.getResource.getResourceParams().getResourceID();
        if (!"_gtn_resid_".equals(id)) {
            resourceInvocation.setResourceId(id);
        }
        WSRPRequestContext requestContext = WSRPRequestContext.createRequestContext(this.markupRequest, resourceParams);
        resourceInvocation.setRequestContext((RequestContext)requestContext);
        resourceInvocation.setForm((Map)requestContext.getForm());
        String validationToken = null;
        resourceInvocation.setValidationToken(validationToken);
        resourceInvocation.setResourceState(this.createNavigationalState(resourceParams.getResourceState()));
        String resourceCacheability = resourceParams.getResourceCacheability();
        if (resourceCacheability != null) {
            CacheLevel cacheLevel = WSRPUtils.getCacheLevelFromResourceCacheability((String)resourceParams.getResourceCacheability());
            resourceInvocation.setCacheLevel(cacheLevel);
        } else {
            resourceInvocation.setCacheLevel(CacheLevel.PAGE);
        }
        return resourceInvocation;
    }

    @Override
    protected ResourceResponse createResponse(ResourceContext resourceContext) {
        return WSRPTypeFactory.createResourceResponse((ResourceContext)resourceContext);
    }

    @Override
    protected Class<ResourceContext> getReifiedClass() {
        return ResourceContext.class;
    }
}

