/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.oauth;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.jsecurity.authc.AccountException;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.SimpleAuthenticationInfo;
import org.jsecurity.authc.UsernamePasswordToken;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.AuthorizationInfo;
import org.jsecurity.authz.SimpleAuthorizationInfo;
import org.jsecurity.realm.AuthorizingRealm;
import org.jsecurity.subject.PrincipalCollection;

public class SampleRealm
extends AuthorizingRealm {
    @Inject
    private static JsonDbOpensocialService jsonDbService;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        if (username == null) {
            throw new AccountException("Null usernames are not allowed by this realm.");
        }
        String password = jsonDbService.getPassword(username);
        return new SimpleAuthenticationInfo((Object)username, (Object)password, this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw new AuthorizationException("PrincipalCollection method argument cannot be null.");
        }
        String username = (String)principals.fromRealm(this.getName()).iterator().next();
        ImmutableSet roleNames = username == null ? ImmutableSet.of() : ImmutableSet.of((Object[])new String[]{"foo", "goo"});
        return new SimpleAuthorizationInfo((Set)roleNames);
    }
}

