/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.cms.link.ItemLinkAware;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.SessionLifecycleListener;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionLinkAware
implements ExtendedSession,
NamespaceAccessor {
    private static final Log LOG = ExoLogger.getLogger((String)"services.cms.link.SessionLinkAware");
    private ItemLinkAware itemLA;
    private final ExtendedSession originalSession;
    private final ExtendedSession currentNodeSession;
    private volatile ExtendedSession targetNodeSession;
    private volatile ExtendedSession[] sessions;

    SessionLinkAware(ItemLinkAware itemLA) throws RepositoryException {
        this.itemLA = itemLA;
        this.originalSession = (ExtendedSession)itemLA.originalSession;
        this.currentNodeSession = (ExtendedSession)itemLA.item.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedSession[] getSessions() throws RepositoryException {
        if (this.sessions == null) {
            SessionLinkAware sessionLinkAware = this;
            synchronized (sessionLinkAware) {
                if (this.sessions == null) {
                    HashSet<ExtendedSession> sSessions = new HashSet<ExtendedSession>(3, 1.0f);
                    sSessions.add(this.originalSession);
                    sSessions.add(this.currentNodeSession);
                    sSessions.add(this.getTargetSession());
                    this.sessions = sSessions.toArray(new ExtendedSession[sSessions.size()]);
                }
            }
        }
        return this.sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedSession getTargetSession() throws RepositoryException {
        if (this.targetNodeSession == null) {
            SessionLinkAware sessionLinkAware = this;
            synchronized (sessionLinkAware) {
                if (this.targetNodeSession == null) {
                    this.targetNodeSession = this.getTargetSession(this.itemLA);
                    this.itemLA = null;
                }
            }
        }
        return this.targetNodeSession;
    }

    private ExtendedSession getTargetSession(String absPath, Item item) throws RepositoryException {
        return this.getTargetSession(ItemLinkAware.newInstance((Session)this.originalSession, absPath, item));
    }

    private ExtendedSession getTargetSession(ItemLinkAware itemLA) throws RepositoryException {
        if (itemLA instanceof NodeLinkAware) {
            return (ExtendedSession)((NodeLinkAware)itemLA).getTargetNode().getRealNode().getSession();
        }
        return (ExtendedSession)itemLA.item.getSession();
    }

    private ExtendedSession getTargetSession(String absPath) throws RepositoryException {
        Item item = this.getItem(absPath);
        return this.getTargetSession(absPath, item);
    }

    public void addLockToken(String lt) {
        try {
            this.getTargetSession().addLockToken(lt);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        this.getTargetSession(absPath).checkPermission(absPath, actions);
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.getTargetSession(absPath).exportDocumentView(absPath, contentHandler, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.getTargetSession(absPath).exportDocumentView(absPath, out, skipBinary, noRecurse);
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.getTargetSession(absPath).exportSystemView(absPath, contentHandler, skipBinary, noRecurse);
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.getTargetSession(absPath).exportSystemView(absPath, out, skipBinary, noRecurse);
    }

    public Object getAttribute(String name) {
        try {
            return this.getTargetSession().getAttribute(name);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public String[] getAttributeNames() {
        try {
            return this.getTargetSession().getAttributeNames();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        return this.getTargetSession(parentAbsPath).getImportContentHandler(parentAbsPath, uuidBehavior);
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        NodeFinder nodeFinder = LinkUtils.getNodeFinder();
        return nodeFinder.getItem((Session)this.originalSession, absPath);
    }

    public String[] getLockTokens() {
        try {
            return this.getTargetSession().getLockTokens();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        return this.getTargetSession().getNamespacePrefix(uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.getTargetSession().getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        return this.getTargetSession().getNamespaceURI(prefix);
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        for (ExtendedSession session : this.getSessions()) {
            try {
                return session.getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
            }
        }
        throw new ItemNotFoundException("No node with uuid ='" + uuid + "' can be found");
    }

    public Repository getRepository() {
        return this.originalSession.getRepository();
    }

    public Node getRootNode() throws RepositoryException {
        return this.originalSession.getRootNode();
    }

    public String getUserID() {
        return this.originalSession.getUserID();
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.originalSession.getValueFactory();
    }

    public Workspace getWorkspace() {
        return this.originalSession.getWorkspace();
    }

    public boolean hasPendingChanges() throws RepositoryException {
        for (ExtendedSession session : this.getSessions()) {
            if (!session.hasPendingChanges()) continue;
            return true;
        }
        return false;
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        return this.originalSession.impersonate(credentials);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        this.getTargetSession(parentAbsPath).importXML(parentAbsPath, in, uuidBehavior);
    }

    public boolean isLive() {
        ExtendedSession[] sessions;
        try {
            sessions = this.getSessions();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            return false;
        }
        for (ExtendedSession session : sessions) {
            if (!session.isLive()) continue;
            return true;
        }
        return false;
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        NodeFinder nodeFinder = LinkUtils.getNodeFinder();
        return nodeFinder.itemExists((Session)this.originalSession, absPath);
    }

    public void logout() {
        ExtendedSession[] sessions;
        try {
            sessions = this.getSessions();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            return;
        }
        for (ExtendedSession session : sessions) {
            session.logout();
        }
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Item srcItem = this.getItem(srcAbsPath);
        ExtendedSession srcSession = this.getTargetSession(srcAbsPath, srcItem);
        ExtendedSession destParentSession = this.getTargetSession(LinkUtils.getParentPath(destAbsPath));
        if (srcSession.getWorkspace().equals(destParentSession.getWorkspace())) {
            srcSession.move(srcAbsPath, srcAbsPath);
        } else {
            destParentSession.getWorkspace().clone(srcSession.getWorkspace().getName(), srcAbsPath, destAbsPath, false);
        }
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        for (ExtendedSession session : this.getSessions()) {
            session.refresh(keepChanges);
        }
    }

    public void removeLockToken(String lt) {
        try {
            this.getTargetSession().removeLockToken(lt);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        for (ExtendedSession session : this.getSessions()) {
            session.save();
        }
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.getTargetSession().setNamespacePrefix(prefix, uri);
    }

    public String getId() {
        try {
            return this.getTargetSession().getId();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public LocationFactory getLocationFactory() {
        try {
            return this.getTargetSession().getLocationFactory();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior, Map<String, Object> context) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, RepositoryException {
        this.getTargetSession(parentAbsPath).importXML(parentAbsPath, in, uuidBehavior, context);
    }

    public void registerLifecycleListener(SessionLifecycleListener listener) {
        try {
            this.getTargetSession().registerLifecycleListener(listener);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
    }

    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return ((NamespaceAccessor)this.getTargetSession()).getAllNamespacePrefixes();
    }

    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return ((NamespaceAccessor)this.getTargetSession()).getNamespacePrefixByURI(uri);
    }

    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException, RepositoryException {
        return ((NamespaceAccessor)this.getTargetSession()).getNamespaceURIByPrefix(prefix);
    }

    public Node getNodeByIdentifier(String identifier) throws ItemNotFoundException, RepositoryException {
        return null;
    }
}

