/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.mgt;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.HostUnauthorizedException;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.cache.CacheManagerAware;
import org.jsecurity.mgt.AuthorizingSecurityManager;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.session.SessionListener;
import org.jsecurity.session.SessionListenerRegistrar;
import org.jsecurity.session.mgt.DefaultSessionManager;
import org.jsecurity.session.mgt.DelegatingSession;
import org.jsecurity.session.mgt.SessionManager;
import org.jsecurity.util.LifecycleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionsSecurityManager
extends AuthorizingSecurityManager
implements SessionListenerRegistrar {
    protected SessionManager sessionManager;

    public SessionsSecurityManager() {
        this.ensureSessionManager();
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected void ensureSessionManager() {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            sessionManager = this.createSessionManager();
            this.setSessionManager(sessionManager);
        }
    }

    protected SessionManager createSessionManager() {
        SessionManager sm = this.newSessionManagerInstance();
        CacheManager cm = this.getCacheManager();
        if (cm != null && sm instanceof CacheManagerAware) {
            ((CacheManagerAware)((Object)sm)).setCacheManager(cm);
        }
        return sm;
    }

    protected SessionManager newSessionManagerInstance() {
        return new DefaultSessionManager();
    }

    @Override
    protected void afterCacheManagerSet() {
        super.afterCacheManagerSet();
        this.applyCacheManagerToSessionManager();
    }

    protected void applyCacheManagerToSessionManager() {
        SessionManager sm = this.getSessionManager();
        if (sm instanceof CacheManagerAware) {
            ((CacheManagerAware)((Object)sm)).setCacheManager(this.cacheManager);
        }
    }

    @Override
    public void setSessionListeners(Collection<SessionListener> sessionListeners) {
        this.assertSessionListenerSupport();
        ((SessionListenerRegistrar)((Object)this.sessionManager)).setSessionListeners(sessionListeners);
    }

    private void assertSessionListenerSupport() throws IllegalStateException {
        if (!(this.sessionManager instanceof SessionListenerRegistrar)) {
            String msg = "SessionListener registration failed:  The underlying SessionManager instance of type [" + this.sessionManager.getClass().getName() + "] does not implement the " + SessionListenerRegistrar.class.getName() + " interface and therefore cannot support " + "session notifications.";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void add(SessionListener listener) {
        this.assertSessionListenerSupport();
        SessionManager sm = this.getSessionManager();
        ((SessionListenerRegistrar)((Object)sm)).add(listener);
    }

    @Override
    public boolean remove(SessionListener listener) {
        SessionManager sm = this.getSessionManager();
        return sm instanceof SessionListenerRegistrar && ((SessionListenerRegistrar)((Object)sm)).remove(listener);
    }

    protected void beforeSessionManagerDestroyed() {
    }

    protected void destroySessionManager() {
        LifecycleUtils.destroy(this.getSessionManager());
    }

    @Override
    protected void beforeAuthorizerDestroyed() {
        this.beforeSessionManagerDestroyed();
        this.destroySessionManager();
    }

    @Override
    public Session start(InetAddress hostAddress) throws HostUnauthorizedException, IllegalArgumentException {
        SessionManager sm = this.getSessionManager();
        Serializable sessionId = sm.start(hostAddress);
        return new DelegatingSession(sm, sessionId);
    }

    @Override
    public Session getSession(Serializable sessionId) throws InvalidSessionException, AuthorizationException {
        SessionManager sm = this.getSessionManager();
        if (!sm.isValid(sessionId)) {
            String msg = "Specified id [" + sessionId + "] does not correspond to a valid Session  It either " + "does not exist or the corresponding session has been stopped or expired.";
            throw new InvalidSessionException(msg, sessionId);
        }
        return new DelegatingSession(sm, sessionId);
    }
}

