/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.webui.component.explorer.versions.UIVersionInfo;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={RemoveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIRemoveLabelForm
extends UIForm {
    private static String FIELD_LABEL = "label";

    public UIRemoveLabelForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_LABEL, FIELD_LABEL, null)).setRendered(false);
    }

    public void update() throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        UIVersionInfo uiVersionInfo = (UIVersionInfo)this.getParent();
        Version version = uiVersionInfo.getCurrentVersionNode().getVersion();
        VersionHistory versionHistory = uiVersionInfo.getCurrentNode().getVersionHistory();
        String[] strOptions = versionHistory.getVersionLabels(version);
        if (strOptions.length <= 0) {
            this.setRendered(false);
        } else {
            for (String temp : strOptions) {
                options.add(new SelectItemOption(temp, (Object)temp));
            }
            ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).setOptions(options);
            this.setRendered(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIRemoveLabelForm> {
        public void execute(Event<UIRemoveLabelForm> event) throws Exception {
            UIRemoveLabelForm uiRemoveLabelForm = (UIRemoveLabelForm)((Object)event.getSource());
            uiRemoveLabelForm.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiRemoveLabelForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIRemoveLabelForm> {
        public void execute(Event<UIRemoveLabelForm> event) throws Exception {
            UIRemoveLabelForm uiRemoveLabelForm = (UIRemoveLabelForm)((Object)event.getSource());
            String label = (String)uiRemoveLabelForm.getUIFormSelectBox(FIELD_LABEL).getValue();
            UIVersionInfo uiVersionInfo = (UIVersionInfo)uiRemoveLabelForm.getParent();
            VersionHistory versionHistory = uiVersionInfo.getCurrentNode().getVersionHistory();
            versionHistory.removeVersionLabel(label);
            UIFormSelectBox box = (UIFormSelectBox)uiRemoveLabelForm.getChild(UIFormSelectBox.class);
            List listValue = box.getOptions();
            Iterator iter = listValue.iterator();
            while (iter.hasNext()) {
                SelectItemOption item = (SelectItemOption)iter.next();
                if (!((String)item.getValue()).equals(label)) continue;
                iter.remove();
            }
            uiRemoveLabelForm.update();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiRemoveLabelForm.getParent());
        }
    }
}

