/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Iterator;
import java.util.List;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class GetTaskInstanceCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -8436697080972165601L;
    private long taskInstanceId;
    private long tokenId;
    private long processInstanceId;

    public GetTaskInstanceCommand() {
    }

    public GetTaskInstanceCommand(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public GetTaskInstanceCommand(long taskInstanceId, boolean includeVariables, boolean includeLogs) {
        super(includeVariables, includeLogs);
        this.taskInstanceId = taskInstanceId;
    }

    public GetTaskInstanceCommand(long taskInstanceId, String[] variablesToInclude) {
        super(variablesToInclude);
        this.taskInstanceId = taskInstanceId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        if (this.taskInstanceId > 0L) {
            TaskInstance taskInstance = jbpmContext.getTaskInstance(this.taskInstanceId);
            if (taskInstance != null) {
                this.retrieveTaskInstanceDetails(taskInstance);
            }
            return taskInstance;
        }
        if (this.tokenId > 0L) {
            List result = jbpmContext.getTaskMgmtSession().findTaskInstancesByToken(this.tokenId);
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                TaskInstance ti = (TaskInstance)iter.next();
                this.retrieveTaskInstanceDetails(ti);
            }
            return result;
        }
        if (this.processInstanceId > 0L) {
            List result = jbpmContext.getTaskMgmtSession().findTaskInstancesByProcessInstance(jbpmContext.getProcessInstance(this.processInstanceId));
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                TaskInstance ti = (TaskInstance)iter.next();
                this.retrieveTaskInstanceDetails(ti);
            }
            return result;
        }
        return null;
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getAdditionalToStringInformation() {
        return "processInstanceId=" + this.processInstanceId + ";tokenId=" + this.tokenId + ";taskInstanceId=" + this.taskInstanceId;
    }

    public GetTaskInstanceCommand taskInstanceId(long taskInstanceId) {
        this.setTaskInstanceId(taskInstanceId);
        return this;
    }

    public GetTaskInstanceCommand tokenId(long tokenId) {
        this.setTokenId(tokenId);
        return this;
    }

    public GetTaskInstanceCommand processInstanceId(long processInstanceId) {
        this.setProcessInstanceId(processInstanceId);
        return this;
    }
}

