/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.Util;

public class HttpHeaderElement {
    private String name;
    private String value;
    private NVPair[] parameters;

    public HttpHeaderElement(String name) {
        this.name = name;
        this.value = null;
        this.parameters = new NVPair[0];
    }

    public HttpHeaderElement(String name, String value, NVPair[] params) {
        this.name = name;
        this.value = value;
        if (params != null) {
            this.parameters = new NVPair[params.length];
            System.arraycopy(params, 0, this.parameters, 0, params.length);
        } else {
            this.parameters = new NVPair[0];
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public NVPair[] getParams() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof HttpHeaderElement) {
            String other = ((HttpHeaderElement)obj).name;
            return this.name.equalsIgnoreCase(other);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendTo(buf);
        return buf.toString();
    }

    public void appendTo(StringBuffer buf) {
        buf.append(this.name);
        if (this.value != null) {
            if (Util.needsQuoting(this.value)) {
                buf.append("=\"");
                buf.append(Util.quoteString(this.value, "\\\""));
                buf.append('\"');
            } else {
                buf.append('=');
                buf.append(this.value);
            }
        }
        for (int idx = 0; idx < this.parameters.length; ++idx) {
            buf.append(";");
            buf.append(this.parameters[idx].getName());
            String pval = this.parameters[idx].getValue();
            if (pval == null) continue;
            if (Util.needsQuoting(pval)) {
                buf.append("=\"");
                buf.append(Util.quoteString(pval, "\\\""));
                buf.append('\"');
                continue;
            }
            buf.append('=');
            buf.append(pval);
        }
    }
}

