/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.model.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActivityProcessorPlugin
extends BaseComponentPlugin
implements ActivityProcessor {
    public static final String TEMPLATE_PARAM_TO_PROCESS = "registeredKeysForProcessor";
    public static final String TEMPLATE_PARAM_LIST_DELIM = "\\|";
    protected int priority;
    private static final Log LOG = ExoLogger.getLogger(BaseActivityProcessorPlugin.class);

    public BaseActivityProcessorPlugin(InitParams params) {
        try {
            this.priority = Integer.valueOf(params.getValueParam("priority").getValue());
            if (this.priority < 1) {
                LOG.warn((Object)"<value-param> 'priority' of type int should be higher than 1");
                this.priority = 1;
            } else if (this.priority > 10) {
                LOG.warn((Object)"<value-param> 'priority' of type int should be lower than 10");
                this.priority = 10;
            }
        }
        catch (Exception e) {
            this.priority = 5;
            LOG.warn((Object)("an <value-param> 'priority' of type int is recommanded for component " + this.getClass()));
        }
    }

    public List<String> getTemplateParamKeysToProcess(Activity activity) {
        Map<String, String> templateParams = activity.getTemplateParams();
        ArrayList<String> keys = new ArrayList<String>();
        if (templateParams != null && templateParams.containsKey(TEMPLATE_PARAM_TO_PROCESS)) {
            return Arrays.asList(activity.getTemplateParams().get(TEMPLATE_PARAM_TO_PROCESS).split(TEMPLATE_PARAM_LIST_DELIM));
        }
        return keys;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public abstract void processActivity(Activity var1);
}

