/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.jcr;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;

public class Util {
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String SLASH_STR = "/";

    public static void createNodes(Node rootNode, String relPath) {
        Validate.notNull((Object)rootNode, (String)"rootNode must not be null");
        Validate.notNull((Object)relPath, (String)"path must not be null");
        try {
            if (rootNode.getNode(relPath) != null) {
                return;
            }
        }
        catch (PathNotFoundException pne) {
        }
        catch (RepositoryException re) {
            throw new RuntimeException(re);
        }
        try {
            if (relPath.indexOf(SLASH_STR) < 0) {
                Node node = rootNode.addNode(relPath);
            } else {
                String[] ar = relPath.split(SLASH_STR);
                for (int i = 0; i < ar.length; ++i) {
                    Node node = rootNode.hasNode(ar[i]) ? rootNode.getNode(ar[i]) : rootNode.addNode(ar[i], NT_UNSTRUCTURED);
                    rootNode = node;
                }
                if (rootNode.isNew()) {
                    rootNode.getSession().save();
                } else {
                    rootNode.getParent().save();
                }
            }
        }
        catch (RepositoryException re) {
            throw new RuntimeException(re);
        }
    }
}

