/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;

public class IndexCleanHelper {
    public void removeWorkspaceIndex(WorkspaceEntry wsConfig, boolean isSystem) throws RepositoryConfigurationException, IOException {
        File systemIndexDir;
        String indexDirName = wsConfig.getQueryHandler().getParameterValue("index-dir");
        File indexDir = new File(indexDirName);
        if (indexDir.exists()) {
            this.removeFolder(indexDir);
        }
        if (isSystem && (systemIndexDir = new File(indexDirName + "_" + "system")).exists()) {
            this.removeFolder(systemIndexDir);
        }
    }

    private void removeFolder(File dir) throws IOException {
        if (dir.isDirectory()) {
            for (File subFile : dir.listFiles()) {
                this.removeFolder(subFile);
            }
            if (!dir.delete()) {
                throw new IOException("Index folder was not deleted : " + dir.getCanonicalPath());
            }
        } else if (!dir.delete()) {
            throw new IOException("Index file was not deleted : " + dir.getCanonicalPath());
        }
    }
}

