/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;

public class SocialUserEventListenerImpl
extends UserEventListener {
    private static final Log LOG = ExoLogger.getExoLogger(SocialUserEventListenerImpl.class);

    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            IdentityManager idm = this.getIdentityManager();
            Identity identity = idm.getOrCreateIdentity("organization", user.getUserName());
            Profile profile = identity.getProfile();
            String pFirstName = (String)profile.getProperty("firstName");
            String pLastName = (String)profile.getProperty("lastName");
            String pEmail = (String)profile.getProperty("email");
            String uFirstName = user.getFirstName();
            String uLastName = user.getLastName();
            String uEmail = user.getEmail();
            boolean hasUpdated = false;
            if (pFirstName == null || !pFirstName.equals(uFirstName)) {
                profile.setProperty("firstName", uFirstName);
                hasUpdated = true;
            }
            if (pLastName == null || !pLastName.equals(uLastName)) {
                profile.setProperty("lastName", uLastName);
                hasUpdated = true;
            }
            if (pEmail == null || !pEmail.equals(uEmail)) {
                profile.setProperty("email", uEmail);
                hasUpdated = true;
            }
            if (hasUpdated) {
                idm.saveProfile(profile);
            }
        }
    }

    public void postDelete(User deletedUser) {
        IdentityManager identityManager = this.getIdentityManager();
        Identity id = identityManager.getOrCreateIdentity("organization", deletedUser.getUserName());
        if (id != null) {
            this.deleteAllActivities(id);
            this.deleteAllConnections(id);
            identityManager.deleteIdentity(id);
        }
    }

    private void deleteAllActivities(Identity deletedIdentity) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActivityManager activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        List<Activity> activities = activityManager.getActivities(deletedIdentity, 0L, activityManager.getActivitiesCount(deletedIdentity));
        for (Activity activity : activities) {
            activityManager.deleteActivity(activity);
        }
    }

    private void deleteAllConnections(Identity deletedIdentity) {
        RelationshipManager relationshipManager = this.getRelationshipManager();
        List<Object> allRelationships = new ArrayList();
        try {
            allRelationships = relationshipManager.getAllRelationships(deletedIdentity);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get all relationships", (Throwable)e);
        }
        for (Relationship relationship : allRelationships) {
            try {
                relationshipManager.remove(relationship);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to remove relationship: " + relationship), (Throwable)e);
            }
        }
    }

    private IdentityManager getIdentityManager() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
    }

    private RelationshipManager getRelationshipManager() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
    }
}

