/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWithTree;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDocumentTabPane.gtmpl", events={@EventConfig(listeners={ChangeTabActionListener.class})})
public class UIDocumentContainer
extends UIContainer {
    public UIDocumentContainer() throws Exception {
        this.addChild(UIDocumentWithTree.class, null, null);
        this.addChild(UIDocumentInfo.class, null, null);
    }

    public boolean isShowViewFile() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isShowViewFile();
    }

    public boolean isJcrEnable() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getPreference().isJcrEnable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTabActionListener
    extends EventListener<UIDocumentContainer> {
        public void execute(Event<UIDocumentContainer> event) throws Exception {
            UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)((Object)event.getSource());
            String selectedTabName = event.getRequestContext().getRequestParameter("objectId");
            UIDocumentWithTree uiDocTree = (UIDocumentWithTree)uiDocumentContainer.getChild(UIDocumentWithTree.class);
            uiDocTree.setRendered(uiDocTree.getId().equals(selectedTabName));
            UIDocumentInfo uiDocInfo = (UIDocumentInfo)uiDocumentContainer.getChildById(UIDocumentInfo.class.getSimpleName());
            uiDocInfo.setRendered(uiDocInfo.getId().equals(selectedTabName));
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentContainer.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.setShowDocumentViewForFile(uiDocInfo.getId().equals(selectedTabName));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentContainer);
            uiExplorer.updateAjax(event);
        }
    }
}

