/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.SimpleSearchValidator;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContentNameSearch
extends UIForm {
    private static String KEYWORD = "keyword".intern();
    private static String SEARCH_LOCATION = "location".intern();
    private static final String ROOT_PATH_SQL_QUERY = "select * from nt:base where jcr:path like '%/$1' order by exo:dateCreated DESC,jcr:primaryType DESC";
    private static final String PATH_SQL_QUERY = "select * from nt:base where jcr:path like '$0/%/$1' or jcr:path like '$0/$1' order by exo:dateCreated DESC,jcr:primaryType DESC";

    public UIContentNameSearch() throws Exception {
        this.addChild((UIComponent)new UIFormInputInfo(SEARCH_LOCATION, null, null));
        this.addChild((UIComponent)new UIFormStringInput(KEYWORD, null).addValidator(SimpleSearchValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0]));
    }

    public void setLocation(String location) {
        this.getUIFormInputInfo(SEARCH_LOCATION).setValue((Object)location);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIContentNameSearch> {
        public void execute(Event<UIContentNameSearch> event) throws Exception {
            ((UIJCRExplorer)((UIContentNameSearch)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIContentNameSearch> {
        public void execute(Event<UIContentNameSearch> event) throws Exception {
            UIContentNameSearch contentNameSearch = (UIContentNameSearch)((Object)event.getSource());
            UIECMSearch uiECMSearch = (UIECMSearch)contentNameSearch.getAncestorOfType(UIECMSearch.class);
            UISearchResult uiSearchResult = (UISearchResult)uiECMSearch.getChild(UISearchResult.class);
            UIApplication application = (UIApplication)contentNameSearch.getAncestorOfType(UIApplication.class);
            try {
                String keyword = (String)contentNameSearch.getUIStringInput(KEYWORD).getValue();
                keyword = keyword.trim();
                UIJCRExplorer explorer = (UIJCRExplorer)contentNameSearch.getAncestorOfType(UIJCRExplorer.class);
                String currentNodePath = explorer.getCurrentNode().getPath();
                String statement = null;
                if ("/".equalsIgnoreCase(currentNodePath)) {
                    statement = StringUtils.replace((String)UIContentNameSearch.ROOT_PATH_SQL_QUERY, (String)"$1", (String)keyword);
                } else {
                    statement = StringUtils.replace((String)UIContentNameSearch.PATH_SQL_QUERY, (String)"$0", (String)currentNodePath);
                    statement = StringUtils.replace((String)statement, (String)"$1", (String)keyword);
                }
                QueryManager queryManager = explorer.getTargetSession().getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(statement, "sql");
                long startTime = System.currentTimeMillis();
                QueryResult queryResult = query.execute();
                uiSearchResult.clearAll();
                uiSearchResult.setQueryResults(queryResult);
                uiSearchResult.updateGrid(true);
                long time = System.currentTimeMillis() - startTime;
                uiSearchResult.setSearchTime(time);
                uiECMSearch.setRenderedChild(UISearchResult.class);
                contentNameSearch.getUIFormInputInfo(SEARCH_LOCATION).setValue((Object)currentNodePath);
            }
            catch (RepositoryException reEx) {
                application.addMessage(new ApplicationMessage("UIContentNameSearch.msg.keyword-not-allowed", null, 1));
                return;
            }
            catch (Exception e) {
                uiSearchResult.clearAll();
                uiSearchResult.setQueryResults(null);
                uiSearchResult.updateGrid(true);
                uiECMSearch.setRenderedChild(UISearchResult.class);
            }
        }
    }
}

