/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.replication.ApplicationState;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.webui.application.ConfigurationManager;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class PortalStateManager
extends StateManager {
    private static final String APPLICATION_ATTRIBUTE_PREFIX = "psm.";
    private static final Logger log = LoggerFactory.getLogger(PortalStateManager.class);

    public UIApplication restoreUIRootComponent(WebuiRequestContext context) throws Exception {
        context.setStateManager((StateManager)this);
        WebuiApplication app = (WebuiApplication)context.getApplication();
        ApplicationState appState = null;
        HttpSession session = this.getSession(context);
        String key = this.getKey(context);
        if (session != null) {
            appState = (ApplicationState)session.getAttribute(APPLICATION_ATTRIBUTE_PREFIX + key);
        }
        UIApplication uiapp = null;
        if (appState != null && Safe.equals((Object)context.getRemoteUser(), (Object)appState.getUserName())) {
            uiapp = appState.getApplication();
        }
        if (appState != null) {
            log.debug((Object)("Found application " + key + " :" + appState.getApplication()));
        } else {
            log.debug((Object)("Application " + key + " not found"));
        }
        if (context instanceof PortalRequestContext) {
            PortalRequestContext portalRC = (PortalRequestContext)context;
            UserPortalConfig config = PortalStateManager.getUserPortalConfig(portalRC);
            if (config == null) {
                HttpServletResponse response = portalRC.getResponse();
                response.sendRedirect(portalRC.getRequest().getContextPath() + "/portal-unavailable.jsp");
                portalRC.setResponseComplete(true);
                return null;
            }
            portalRC.setAttribute(UserPortalConfig.class, config);
        }
        if (uiapp == null) {
            ConfigurationManager cmanager = app.getConfigurationManager();
            String uirootClass = cmanager.getApplication().getUIRootComponent();
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(uirootClass);
            uiapp = (UIApplication)app.createUIComponent(type, null, null, context);
        }
        return uiapp;
    }

    public void storeUIRootComponent(WebuiRequestContext context) throws Exception {
        HttpSession session;
        UIApplication uiapp = context.getUIApplication();
        if (uiapp != null && (session = this.getSession(context)) != null) {
            String key = this.getKey(context);
            log.debug((Object)("Storing application " + key));
            session.setAttribute(APPLICATION_ATTRIBUTE_PREFIX + key, (Object)new ApplicationState(uiapp, context.getRemoteUser()));
        }
    }

    public void expire(String sessionId, WebuiApplication app) throws Exception {
    }

    public static UserPortalConfig getUserPortalConfig(PortalRequestContext context) throws Exception {
        ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService service_ = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        String remoteUser = context.getRemoteUser();
        String ownerUser = context.getPortalOwner();
        return service_.getUserPortalConfig(ownerUser, remoteUser);
    }

    private String getKey(WebuiRequestContext webuiRC) {
        if (webuiRC instanceof PortletRequestContext) {
            PortletRequestContext portletRC = (PortletRequestContext)webuiRC;
            return portletRC.getApplication().getApplicationId() + "/" + portletRC.getWindowId();
        }
        PortalRequestContext portalRC = (PortalRequestContext)webuiRC;
        String portalOwner = portalRC.getPortalOwner();
        return "portal_" + portalOwner;
    }

    private HttpSession getSession(WebuiRequestContext webuiRC) {
        PortalRequestContext portalRC;
        if (webuiRC instanceof PortletRequestContext) {
            PortletRequestContext portletRC = (PortletRequestContext)webuiRC;
            portalRC = (PortalRequestContext)portletRC.getParentAppRequestContext();
        } else {
            portalRC = (PortalRequestContext)webuiRC;
        }
        HttpServletRequest req = portalRC.getRequest();
        return req.getSession(false);
    }
}

