/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessClassLoader
extends ClassLoader {
    private ProcessDefinition processDefinition;
    private long processDefinitionId;

    public ProcessClassLoader(ClassLoader parent, ProcessDefinition processDefinition) {
        super(parent);
        long id = processDefinition.getId();
        if (id != 0L) {
            this.processDefinitionId = id;
        } else {
            this.processDefinition = processDefinition;
        }
    }

    protected ProcessDefinition getProcessDefinition() {
        return this.processDefinition != null ? this.processDefinition : JbpmContext.getCurrentJbpmContext().getGraphSession().loadProcessDefinition(this.processDefinitionId);
    }

    public URL findResource(String name) {
        ProcessDefinition processDefinition = this.getProcessDefinition();
        FileDefinition fileDefinition = processDefinition.getFileDefinition();
        if (fileDefinition != null) {
            int off;
            int len = name.length();
            for (off = 0; off < len && name.charAt(off) == '/'; ++off) {
            }
            name = off > 0 ? name.substring(off) : "classes/" + name;
            byte[] bytes = null;
            if (fileDefinition.hasFile(name)) {
                bytes = fileDefinition.getBytes(name);
            }
            if (bytes != null) {
                try {
                    return new URL(null, "processresource://" + processDefinition.getName() + "/classes/" + name, new BytesUrlStreamHandler(bytes));
                }
                catch (MalformedURLException e) {
                    throw new JbpmException("couldn't create url", e);
                }
            }
        }
        return null;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        String fileName;
        byte[] classBytes;
        ProcessDefinition processDefinition = this.getProcessDefinition();
        FileDefinition fileDefinition = processDefinition.getFileDefinition();
        if (fileDefinition != null && (classBytes = fileDefinition.getBytes(fileName = "classes/" + className.replace('.', '/') + ".class")) != null) {
            String packageName;
            int packageIndex = className.lastIndexOf(46);
            if (packageIndex != -1 && this.getPackage(packageName = className.substring(0, packageIndex)) == null) {
                Package jbpmPackage = ProcessClassLoader.class.getPackage();
                this.definePackage(packageName, processDefinition.getName(), Integer.toString(processDefinition.getVersion()), null, jbpmPackage.getImplementationTitle(), jbpmPackage.getImplementationVersion(), jbpmPackage.getImplementationVersion(), null);
            }
            return this.defineClass(className, classBytes, 0, classBytes.length);
        }
        throw new ClassNotFoundException(className);
    }

    public static class BytesUrlConnection
    extends URLConnection {
        byte[] bytes = null;

        public BytesUrlConnection(byte[] bytes, URL u) {
            super(u);
            this.bytes = bytes;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class BytesUrlStreamHandler
    extends URLStreamHandler {
        byte[] bytes;

        public BytesUrlStreamHandler(byte[] bytes) {
            this.bytes = bytes;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new BytesUrlConnection(this.bytes, u);
        }
    }
}

