/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.Version;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.diff.AddDelta;
import org.exoplatform.services.document.diff.ChangeDelta;
import org.exoplatform.services.document.diff.DeleteDelta;
import org.exoplatform.services.document.diff.Delta;
import org.exoplatform.services.document.diff.DiffService;
import org.exoplatform.services.document.diff.Revision;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/versions/UIDiff.gtmpl")
public class UIDiff
extends UIComponent {
    private Version baseVersion_;
    private Version version_;
    private boolean versionCompareable_ = true;

    public void setVersions(Version baseVersion, Version version) throws Exception {
        this.baseVersion_ = baseVersion;
        this.version_ = version;
    }

    public String getText(Node node) throws Exception {
        Node content;
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("jcr:mimeType")) {
            String mimeType = content.getProperty("jcr:mimeType").getString();
            if (content.hasProperty("jcr:data")) {
                if (mimeType.startsWith("text")) {
                    return content.getProperty("jcr:data").getString();
                }
                DocumentReaderService readerService = (DocumentReaderService)this.getApplicationComponent(DocumentReaderService.class);
                try {
                    return readerService.getDocumentReader(mimeType).getContentAsText(content.getProperty("jcr:data").getStream());
                }
                catch (Exception e) {
                    this.versionCompareable_ = false;
                }
            }
        }
        return null;
    }

    public String getBaseVersionNum() throws Exception {
        return this.baseVersion_.getName();
    }

    public String getCurrentVersionNum() throws Exception {
        return this.version_.getName();
    }

    public String getBaseVersionDate() throws Exception {
        return this.formatDate(this.baseVersion_.getCreated());
    }

    public String getCurrentVersionDate() throws Exception {
        return this.formatDate(this.version_.getCreated());
    }

    private String formatDate(Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return dateFormat.format(calendar.getTime());
    }

    public boolean isCompareable() {
        return this.versionCompareable_;
    }

    public List<Delta> getDeltas() throws Exception {
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        String previousText = this.getText(this.version_.getNode("jcr:frozenNode"));
        String currentText = this.getText(this.baseVersion_.getNode("jcr:frozenNode"));
        if (previousText != null && currentText != null) {
            String lineSeparator = DiffService.NL;
            Object[] orig = StringUtils.split((String)previousText, (String)lineSeparator);
            Object[] rev = StringUtils.split((String)currentText, (String)lineSeparator);
            DiffService diffService = (DiffService)this.getApplicationComponent(DiffService.class);
            Revision revision = diffService.diff(orig, rev);
            for (int i = 0; i < revision.size(); ++i) {
                deltas.add(revision.getDelta(i));
            }
        }
        return deltas;
    }

    public boolean isDeleteDelta(Delta delta) {
        return delta instanceof DeleteDelta;
    }

    public boolean isAddDelta(Delta delta) {
        return delta instanceof AddDelta;
    }

    public boolean isChangeDelta(Delta delta) {
        return delta instanceof ChangeDelta;
    }
}

