/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManager {
    private static final Logger logger = Logger.getLogger(StateManager.class.getName());
    private HashMap<Reference, PObject> changes;
    private PTrailer trailer;
    private int nextReferenceNumber;

    public StateManager(PTrailer trailer) {
        this.trailer = trailer;
        this.changes = new HashMap();
        if (trailer != null) {
            this.nextReferenceNumber = trailer.getNumberOfObjects();
        }
    }

    public Reference getNewReferencNumber() {
        Reference newReference = new Reference(this.nextReferenceNumber, 0);
        ++this.nextReferenceNumber;
        return newReference;
    }

    public void addChange(PObject pObject) {
        this.changes.put(pObject.getReference(), pObject);
    }

    public boolean contains(Reference reference) {
        return this.changes.containsKey(reference);
    }

    public void removeChange(PObject pObject) {
        this.changes.remove(pObject.getReference());
    }

    public boolean isChanged() {
        return !this.changes.isEmpty();
    }

    public Iterator<PObject> iteratorSortedByObjectNumber() {
        Collection<PObject> coll = this.changes.values();
        PObject[] arr = coll.toArray(new PObject[coll.size()]);
        Arrays.sort(arr, new PObjectComparatorByReferenceObjectNumber());
        List<PObject> sortedList = Arrays.asList(arr);
        return sortedList.iterator();
    }

    public PTrailer getTrailer() {
        return this.trailer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PObjectComparatorByReferenceObjectNumber
    implements Comparator<PObject> {
        private PObjectComparatorByReferenceObjectNumber() {
        }

        @Override
        public int compare(PObject a, PObject b) {
            int bron;
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            Reference ar = a.getReference();
            Reference br = b.getReference();
            if (ar == null && br == null) {
                return 0;
            }
            if (ar == null) {
                return -1;
            }
            if (br == null) {
                return 1;
            }
            int aron = ar.getObjectNumber();
            if (aron < (bron = br.getObjectNumber())) {
                return -1;
            }
            if (aron > bron) {
                return 1;
            }
            return 0;
        }
    }
}

