/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.LittleEndian;

public final class SlideAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 1007L;
    public static final int MASTER_SLIDE_ID = 0;
    public static final int USES_MASTER_SLIDE_ID = Integer.MIN_VALUE;
    private int masterID;
    private int notesID;
    private boolean followMasterObjects;
    private boolean followMasterScheme;
    private boolean followMasterBackground;
    private SSlideLayoutAtom layoutAtom;
    private byte[] reserved;

    public int getMasterID() {
        return this.masterID;
    }

    public void setMasterID(int id) {
        this.masterID = id;
    }

    public int getNotesID() {
        return this.notesID;
    }

    public SSlideLayoutAtom getSSlideLayoutAtom() {
        return this.layoutAtom;
    }

    public void setNotesID(int id) {
        this.notesID = id;
    }

    public boolean getFollowMasterObjects() {
        return this.followMasterObjects;
    }

    public boolean getFollowMasterScheme() {
        return this.followMasterScheme;
    }

    public boolean getFollowMasterBackground() {
        return this.followMasterBackground;
    }

    public void setFollowMasterObjects(boolean flag) {
        this.followMasterObjects = flag;
    }

    public void setFollowMasterScheme(boolean flag) {
        this.followMasterScheme = flag;
    }

    public void setFollowMasterBackground(boolean flag) {
        this.followMasterBackground = flag;
    }

    protected SlideAtom(byte[] source, int start, int len) {
        if (len < 30) {
            len = 30;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        byte[] SSlideLayoutAtomData = new byte[12];
        System.arraycopy(source, start + 8, SSlideLayoutAtomData, 0, 12);
        this.layoutAtom = new SSlideLayoutAtom(SSlideLayoutAtomData);
        this.masterID = LittleEndian.getInt((byte[])source, (int)(start + 12 + 8));
        this.notesID = LittleEndian.getInt((byte[])source, (int)(start + 16 + 8));
        int flags = LittleEndian.getUShort((byte[])source, (int)(start + 20 + 8));
        this.followMasterBackground = (flags & 4) == 4;
        this.followMasterScheme = (flags & 2) == 2;
        this.followMasterObjects = (flags & 1) == 1;
        this.reserved = new byte[len - 30];
        System.arraycopy(source, start + 30, this.reserved, 0, this.reserved.length);
    }

    public SlideAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)2);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)((int)_type));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)24);
        byte[] ssdate = new byte[12];
        this.layoutAtom = new SSlideLayoutAtom(ssdate);
        this.layoutAtom.setGeometryType(16);
        this.followMasterObjects = true;
        this.followMasterScheme = true;
        this.followMasterBackground = true;
        this.masterID = Integer.MIN_VALUE;
        this.notesID = 0;
        this.reserved = new byte[2];
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        this.layoutAtom.writeOut(out);
        SlideAtom.writeLittleEndian(this.masterID, out);
        SlideAtom.writeLittleEndian(this.notesID, out);
        short flags = 0;
        if (this.followMasterObjects) {
            flags = (short)(flags + 1);
        }
        if (this.followMasterScheme) {
            flags = (short)(flags + 2);
        }
        if (this.followMasterBackground) {
            flags = (short)(flags + 4);
        }
        SlideAtom.writeLittleEndian(flags, out);
        out.write(this.reserved);
    }

    public class SSlideLayoutAtom {
        public static final int TITLE_SLIDE = 0;
        public static final int TITLE_BODY_SLIDE = 1;
        public static final int TITLE_MASTER_SLIDE = 2;
        public static final int MASTER_SLIDE = 3;
        public static final int MASTER_NOTES = 4;
        public static final int NOTES_TITLE_BODY = 5;
        public static final int HANDOUT = 6;
        public static final int TITLE_ONLY = 7;
        public static final int TITLE_2_COLUMN_BODY = 8;
        public static final int TITLE_2_ROW_BODY = 9;
        public static final int TITLE_2_COLUNM_RIGHT_2_ROW_BODY = 10;
        public static final int TITLE_2_COLUNM_LEFT_2_ROW_BODY = 11;
        public static final int TITLE_2_ROW_BOTTOM_2_COLUMN_BODY = 12;
        public static final int TITLE_2_ROW_TOP_2_COLUMN_BODY = 13;
        public static final int FOUR_OBJECTS = 14;
        public static final int BIG_OBJECT = 15;
        public static final int BLANK_SLIDE = 16;
        public static final int VERTICAL_TITLE_BODY_LEFT = 17;
        public static final int VERTICAL_TITLE_2_ROW_BODY_LEFT = 17;
        private int geometry;
        private byte[] placeholderIDs;

        public int getGeometryType() {
            return this.geometry;
        }

        public void setGeometryType(int geom) {
            this.geometry = geom;
        }

        public SSlideLayoutAtom(byte[] data) {
            if (data.length != 12) {
                throw new RuntimeException("SSlideLayoutAtom created with byte array not 12 bytes long - was " + data.length + " bytes in size");
            }
            this.geometry = LittleEndian.getInt((byte[])data, (int)0);
            this.placeholderIDs = new byte[8];
            System.arraycopy(data, 4, this.placeholderIDs, 0, 8);
        }

        public void writeOut(OutputStream out) throws IOException {
            Record.writeLittleEndian(this.geometry, out);
            out.write(this.placeholderIDs);
        }
    }
}

