/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetBlacklist;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.variables.VariableSubstituter;

@Singleton
public class Processor {
    private static final Logger LOG = Logger.getLogger(Processor.class.getName());
    private final GadgetSpecFactory gadgetSpecFactory;
    private final VariableSubstituter substituter;
    private final ContainerConfig containerConfig;
    private final GadgetBlacklist blacklist;
    private final GadgetFeatureRegistry gadgetFeatureRegistry;

    @Inject
    public Processor(GadgetSpecFactory gadgetSpecFactory, VariableSubstituter substituter, ContainerConfig containerConfig, GadgetBlacklist blacklist, GadgetFeatureRegistry gadgetFeatureRegistry) {
        this.gadgetSpecFactory = gadgetSpecFactory;
        this.substituter = substituter;
        this.blacklist = blacklist;
        this.containerConfig = containerConfig;
        this.gadgetFeatureRegistry = gadgetFeatureRegistry;
    }

    public Gadget process(GadgetContext context) throws ProcessingException {
        Uri url = context.getUrl();
        if (url == null) {
            throw new ProcessingException("Missing or malformed url parameter");
        }
        if (!"http".equalsIgnoreCase(url.getScheme()) && !"https".equalsIgnoreCase(url.getScheme())) {
            throw new ProcessingException("Unsupported scheme (must be http or https).");
        }
        if (this.blacklist.isBlacklisted(context.getUrl())) {
            LOG.info("Attempted to render blacklisted gadget: " + context.getUrl());
            throw new ProcessingException("The requested gadget is unavailable");
        }
        try {
            GadgetSpec spec = this.gadgetSpecFactory.getGadgetSpec(context);
            spec = this.substituter.substitute(context, spec);
            return new Gadget().setContext(context).setGadgetFeatureRegistry(this.gadgetFeatureRegistry).setSpec(spec).setCurrentView(this.getView(context, spec));
        }
        catch (GadgetException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private View getView(GadgetContext context, GadgetSpec spec) {
        String viewName = context.getView();
        View view = spec.getView(viewName);
        if (view == null) {
            String container = context.getContainer();
            String property = "${Cur['gadgets.features'].views['" + viewName + "'].aliases}";
            for (Object alias : this.containerConfig.getList(container, property)) {
                viewName = alias.toString();
                view = spec.getView(viewName);
                if (view == null) continue;
                return view;
            }
        }
        if (view == null) {
            view = spec.getView("default");
        }
        return view;
    }
}

