/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.internal.jts.Implementations;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.lifecycle.ShutdownOTS;
import com.arjuna.ats.internal.jts.orbspecific.CurrentImple;
import com.arjuna.ats.internal.jts.orbspecific.TransactionFactoryImple;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.IOException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.PortableServer.Servant;

public class OTSImpleManager {
    private static TransactionFactoryImple _theFactory = null;
    private static TransactionFactory _theFactoryRef = null;
    private static CurrentImple _current = null;
    private static Current _currentRef = null;

    public static CurrentImple current() throws SystemException {
        OTSImpleManager.init();
        _current.contextManager().associate();
        return _current;
    }

    public static CurrentImple systemCurrent() throws SystemException {
        OTSImpleManager.init();
        return _current;
    }

    public static Current get_current() throws SystemException {
        OTSImpleManager.init();
        _current.contextManager().associate();
        return _currentRef;
    }

    public static TransactionFactoryImple factory() throws SystemException {
        OTSImpleManager.init();
        return _theFactory;
    }

    public static TransactionFactory get_factory() throws SystemException {
        OTSImpleManager.init();
        if (_theFactoryRef == null) {
            try {
                _theFactoryRef = _theFactory.getReference();
            }
            catch (Exception e) {
                throw new UNKNOWN();
            }
        }
        return _theFactoryRef;
    }

    public static boolean localFactory() {
        OTSImpleManager.init();
        return _theFactory != null;
    }

    public static void purge() {
        if (_currentRef != null) {
            _currentRef = null;
            _current = null;
        }
        if (_theFactoryRef != null) {
            ORBManager.getPOA().shutdownObject((Servant)_theFactory);
            _theFactory = null;
        }
    }

    private static final synchronized void init() {
        if (_current == null) {
            block23: {
                if (_theFactory == null) {
                    String transactionManager = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jts.transactionManager", "NO");
                    int resolver = 0;
                    boolean requireTransactionManager = false;
                    if (transactionManager.compareTo("YES") == 0) {
                        requireTransactionManager = true;
                        String resolveMechanism = jtsPropertyManager.propertyManager.getProperty("com.arjuna.orbportability.resolveService", "CONFIGURATION_FILE");
                        if (resolveMechanism.compareTo("NAME_SERVICE") == 0) {
                            resolver = 2;
                        } else if (resolveMechanism.compareTo("BIND_CONNECT") == 0) {
                            resolver = 5;
                        }
                    }
                    if (requireTransactionManager) {
                        try {
                            if (resolver != 5) {
                                java.lang.Object[] params = new String[]{"OTS"};
                                Object obj = ORBManager.getServices().getService("TransactionManagerService", params, resolver);
                                params = null;
                                _theFactoryRef = TransactionFactoryHelper.narrow((Object)obj);
                            }
                            if (_theFactoryRef == null) {
                                throw new BAD_PARAM();
                            }
                            break block23;
                        }
                        catch (InvalidName e1) {
                            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.otsserverfailed", new java.lang.Object[]{e1});
                            }
                            throw new FatalError(e1.toString());
                        }
                        catch (BAD_PARAM ex1) {
                            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.otsserverfailed", new java.lang.Object[]{ex1});
                            }
                            throw new FatalError(ex1.toString());
                        }
                        catch (IOException e2) {
                            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.otsservererror", new java.lang.Object[]{e2});
                            }
                            throw new FatalError(e2.toString());
                        }
                        catch (SystemException e3) {
                            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.otsservererror", new java.lang.Object[]{e3});
                            }
                            throw new FatalError(e3.toString());
                        }
                        catch (UserException e4) {
                            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.otsservererror", new java.lang.Object[]{e4});
                            }
                            throw new FatalError(e4.toString());
                        }
                    }
                    _theFactory = new TransactionFactoryImple();
                }
            }
            if (_current == null) {
                try {
                    _current = new CurrentImple();
                    _currentRef = _current;
                }
                catch (Exception e) {
                    _current = null;
                    throw new FatalError("OTSImpleManager.current: " + e.toString());
                }
            }
        }
    }

    static {
        ORBManager.getPOA().addPreShutdown(new ShutdownOTS());
        if (!Implementations.added()) {
            Implementations.initialise();
        }
    }
}

