/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.actions.services.InstallServiceAction;
import com.install4j.runtime.beans.screens.ChecklistScreen;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.InstallerContextImpl;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class ServicesScreen
extends ChecklistScreen {
    private boolean hiddenForPrevious;
    static /* synthetic */ Class class$com$install4j$runtime$beans$actions$services$InstallServiceAction;

    public boolean isHidden() {
        return this.getServiceDataList().size() == 0 || Util.isWindowsInstaller() && Util.isWindows9X();
    }

    public void activated() {
        super.activated();
        this.hiddenForPrevious = true;
        SingleServicePanel singleServicePanel = null;
        Iterator iterator = this.singleCheckPanels.iterator();
        while (iterator.hasNext()) {
            SingleServicePanel singleServicePanel2 = (SingleServicePanel)iterator.next();
            boolean bl = ComponentConfig.isIncludedInSelectedComponents(singleServicePanel2.getServiceData().config.getFile());
            singleServicePanel2.setVisible(bl);
            singleServicePanel2.setSeparatorVisible(bl);
            if (bl) {
                singleServicePanel = singleServicePanel2;
            }
            if (!bl) continue;
            this.hiddenForPrevious = false;
        }
        if (singleServicePanel != null && this.singleCheckPanels.indexOf(singleServicePanel) != this.singleCheckPanels.size() - 1) {
            singleServicePanel.setSeparatorVisible(false);
        }
        if (this.hiddenForPrevious) {
            this.getInstallerContext().goForward(1, true, true);
        }
    }

    public boolean isHiddenForPrevious() {
        return this.hiddenForPrevious;
    }

    public String getTitle() {
        if (Util.isWindowsInstaller()) {
            return this.getMessage("WindowsServicesTitle");
        }
        if (Util.isMacosInstaller()) {
            return this.getMessage("MacosStartupItemsTitle");
        }
        if (Util.isUnixInstaller()) {
            return this.getMessage("UnixDaemonsTitle");
        }
        throw new RuntimeException();
    }

    public String getSubTitle() {
        if (Util.isWindowsInstaller()) {
            return this.getMessage("WindowsServicesSubtitle");
        }
        if (Util.isMacosInstaller()) {
            return this.getMessage("MacosStartupItemsSubTitle");
        }
        if (Util.isUnixInstaller()) {
            return MessageFormat.format(this.getMessage("UnixDaemonsSubTitle"), this.getApplicationName());
        }
        throw new RuntimeException();
    }

    protected void addSingleChecks(GridBagConstraints gridBagConstraints) {
        Iterator iterator = this.getServiceDataList().iterator();
        while (iterator.hasNext()) {
            ServiceData serviceData = (ServiceData)iterator.next();
            SingleServicePanel singleServicePanel = this.createSingleServicePanel(serviceData);
            this.singleCheckPanels.add(singleServicePanel);
            if (gridBagConstraints == null) continue;
            this.checklistPanel.add((Component)singleServicePanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            if (!iterator.hasNext()) continue;
            gridBagConstraints.insets.left += CHECKBOX_WIDTH;
            gridBagConstraints.insets.right += CHECKBOX_WIDTH;
            JSeparator jSeparator = new JSeparator(0);
            this.checklistPanel.add((Component)jSeparator, gridBagConstraints);
            singleServicePanel.setSeparator(jSeparator);
            gridBagConstraints.insets.left -= CHECKBOX_WIDTH;
            gridBagConstraints.insets.right -= CHECKBOX_WIDTH;
            ++gridBagConstraints.gridy;
        }
    }

    protected SingleServicePanel createSingleServicePanel(ServiceData serviceData) {
        if (Util.isWindowsInstaller()) {
            return new Win32SingleServicePanel(serviceData);
        }
        if (Util.isMacosInstaller()) {
            return new MacosSingleServicePanel(serviceData);
        }
        if (Util.isUnixInstaller()) {
            return new UnixSingleServicePanel(serviceData);
        }
        throw new RuntimeException();
    }

    private List getServiceDataList() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        List list = this.getInstallServiceActions();
        ArrayList<ServiceData> arrayList = new ArrayList<ServiceData>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            InstallServiceAction installServiceAction = (InstallServiceAction)iterator.next();
            ServiceConfig serviceConfig = installerConfig.getServiceConfigById(installServiceAction.getLauncherId());
            if (serviceConfig == null || !installServiceAction.isAddToScreen()) continue;
            arrayList.add(new ServiceData(serviceConfig, installServiceAction));
        }
        return arrayList;
    }

    private List getInstallServiceActions() {
        InstallerContextImpl installerContextImpl = (InstallerContextImpl)this.getInstallerContext();
        return installerContextImpl.getExecutableActionsStartingFrom(class$com$install4j$runtime$beans$actions$services$InstallServiceAction == null ? (class$com$install4j$runtime$beans$actions$services$InstallServiceAction = ServicesScreen.class$("com.install4j.runtime.beans.actions.services.InstallServiceAction")) : class$com$install4j$runtime$beans$actions$services$InstallServiceAction, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ServiceData {
        private ServiceConfig config;
        private InstallServiceAction action;

        public ServiceData(ServiceConfig serviceConfig, InstallServiceAction installServiceAction) {
            this.config = serviceConfig;
            this.action = installServiceAction;
        }
    }

    private class UnixSingleServicePanel
    extends SingleServicePanel {
        public UnixSingleServicePanel(ServiceData serviceData) {
            super(serviceData);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(3, 5, 0, 10);
            this.add((Component)new JLabel(MessageFormat.format(ServicesScreen.this.getMessage("UnixDaemonStartStopScriptLabel"), serviceData.config.getName())), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.left += SystemScreen.CHECKBOX_WIDTH;
            JLabel jLabel = new JLabel(serviceData.config.getFile());
            Font font = new Font("Dialog", 1, jLabel.getFont().getSize());
            jLabel.setFont(font);
            this.add((Component)jLabel, gridBagConstraints);
        }

        public void handleConsole(Console console) {
            console.println(MessageFormat.format(ServicesScreen.this.getMessage("UnixDaemonStartStopScriptLabel"), this.getServiceData().config.getName()));
        }
    }

    private class MacosSingleServicePanel
    extends SingleServicePanel {
        public MacosSingleServicePanel(ServiceData serviceData) {
            super(serviceData);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(3, 5, 0, 10);
            this.chkSingle = new JCheckBox(MessageFormat.format(ServicesScreen.this.getMessage("MacosStartupItemInstallCheckbox"), serviceData.config.getName()), serviceData.action.isSelected());
            this.add((Component)this.chkSingle, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }

        public void save() {
            this.getServiceData().action.setSelected(this.chkSingle.isSelected());
        }
    }

    protected class Win32SingleServicePanel
    extends SingleServicePanel
    implements ActionListener {
        private JCheckBox chkAutoStart;

        public Win32SingleServicePanel(ServiceData serviceData) {
            super(serviceData);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(3, 5, 0, 10);
            this.chkSingle = new JCheckBox(MessageFormat.format(ServicesScreen.this.getMessage("WindowsServiceInstallCheckbox"), serviceData.config.getName()), serviceData.action.isSelected());
            this.add((Component)this.chkSingle, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.chkAutoStart = new JCheckBox(ServicesScreen.this.getMessage("WindowsServiceStartOnBootupCheckbox"), serviceData.config.getStartupType().equals("auto"));
            if (serviceData.action.isAllowUserChangeStartType()) {
                gridBagConstraints.insets.top = 0;
                gridBagConstraints.insets.left += SystemScreen.CHECKBOX_WIDTH;
                this.add((Component)this.chkAutoStart, gridBagConstraints);
            }
            this.chkSingle.addActionListener(this);
            this.checkEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.chkSingle) {
                this.checkEnabled();
            }
        }

        public void save() {
            ServiceData serviceData = this.getServiceData();
            serviceData.action.setSelected(this.chkSingle.isSelected());
            serviceData.config.setStartupType(this.chkAutoStart.isSelected() ? "auto" : "manual");
        }

        private void checkEnabled() {
            this.chkAutoStart.setEnabled(this.chkSingle.isSelected());
        }

        public void handleConsole(Console console) throws UserCanceledException {
            super.handleConsole(console);
            if (this.getServiceData().action.isAllowUserChangeStartType()) {
                this.chkAutoStart.setSelected(console.askYesNo(this.chkAutoStart.getText(), this.chkAutoStart.isSelected()));
                this.save();
            }
        }
    }

    private class SingleServicePanel
    extends ChecklistScreen.SingleCheckPanel {
        private ServiceData serviceData;
        private JSeparator separator;

        protected SingleServicePanel(ServiceData serviceData) {
            this.serviceData = serviceData;
        }

        public ServiceData getServiceData() {
            return this.serviceData;
        }

        public void setSeparator(JSeparator jSeparator) {
            this.separator = jSeparator;
        }

        public void setSeparatorVisible(boolean bl) {
            if (this.separator != null) {
                this.separator.setVisible(bl);
            }
        }
    }
}

