/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.exoplatform.portal.resource.Resource;

class SimpleResourceContext {
    private final String contextPath;
    private final ServletContext context;

    public SimpleResourceContext(String contextPath, ServletContext context) {
        this.contextPath = contextPath;
        this.context = context;
    }

    public Resource getResource(String path) {
        int i2 = path.lastIndexOf("/") + 1;
        String targetedParentPath = path.substring(0, i2);
        String targetedFileName = path.substring(i2);
        try {
            final URL url = this.context.getResource(path);
            if (url != null) {
                return new Resource(this.contextPath, targetedParentPath, targetedFileName){

                    public Reader read() throws IOException {
                        return new InputStreamReader(url.openStream());
                    }
                };
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

