/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.LinkedList;
import org.gatein.common.logging.Logger;
import org.gatein.pc.controller.EventProduction;
import org.gatein.pc.controller.event.EventPhaseContext;
import org.gatein.pc.controller.event.PortletWindowEvent;

class EventPhaseContextImpl
implements EventPhaseContext {
    static final int READ_MODE = 0;
    static final int READ_WRITE_MODE = 1;
    static final int INTERRUPTED_MODE = 2;
    private final Logger log;
    LinkedList<EventProduction> producedEvents;
    LinkedList<PortletWindowEvent> toConsumeEvents;
    int consumedEventSize;
    int producedEventSize;
    int mode;

    EventPhaseContextImpl(Logger log) {
        this.log = log;
        this.producedEvents = new LinkedList();
        this.toConsumeEvents = new LinkedList();
        this.consumedEventSize = 0;
        this.producedEventSize = 0;
        this.mode = 0;
    }

    @Override
    public void queueEvent(PortletWindowEvent event) {
        if (this.mode == 2) {
            throw new IllegalStateException("The event phase cannot queue events because it is interruped");
        }
        if (this.mode == 0) {
            throw new IllegalStateException("The event phase cannot queue events");
        }
        if (event == null) {
            throw new IllegalArgumentException("No null event accepted");
        }
        this.log.trace((Object)("Queued event " + event + " in the session"));
        this.toConsumeEvents.addLast(event);
    }

    @Override
    public void interrupt() {
        if (this.mode == 0) {
            throw new IllegalStateException("The event phase is not interruptable");
        }
        this.log.trace((Object)"Event delivery interruped");
        this.mode = 2;
    }
}

