/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.WorkspaceRestoreException;
import org.exoplatform.services.jcr.ext.backup.impl.JobWorkspaceRestore;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JobExistingWorkspaceRestore
extends JobWorkspaceRestore {
    private static final Log LOG = ExoLogger.getLogger("exo.jcr.component.ext.JobExistedWorkspaceRestore");

    public JobExistingWorkspaceRestore(RepositoryService repositoryService, BackupManager backupManager, String repositoryName, BackupChainLog log, WorkspaceEntry wEntry) {
        super(repositoryService, backupManager, repositoryName, log, wEntry);
    }

    protected void restoreWorkspace() throws WorkspaceRestoreException {
        try {
            WorkspaceEntry wEntry = null;
            for (WorkspaceEntry entry : this.repositoryService.getRepository(this.repositoryName).getConfiguration().getWorkspaceEntries()) {
                if (!entry.getName().equals(this.wEntry.getName())) continue;
                wEntry = entry;
                break;
            }
            if (wEntry == null) {
                throw new WorkspaceRestoreException("Workspace " + this.wEntry.getName() + " did not found in current repository " + this.repositoryName + " configuration");
            }
            List backupable = this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class);
            this.forceCloseSession(this.repositoryName, wEntry.getName());
            this.repositoryService.getRepository(this.repositoryName).removeWorkspace(wEntry.getName());
            for (Backupable component : backupable) {
                component.clean();
            }
            super.restoreWorkspace();
        }
        catch (Throwable t) {
            throw new WorkspaceRestoreException("Workspace " + this.wEntry.getName() + " was not restored", t);
        }
    }

    protected void removeWorkspace(ManageableRepository mr, String workspaceName) throws RepositoryException {
    }

    private int forceCloseSession(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository mr = this.repositoryService.getRepository(repositoryName);
        WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
        SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
        return sessionRegistry.closeSessions(workspaceName);
    }
}

