/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.ConstLocalOptimization;
import com.google.caja.parser.js.Block;
import com.google.caja.util.CajaTestCase;

public class ConstLocalOptimizationTest
extends CajaTestCase {
    public final void testAssignedInClosure() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  var isIE = true;  return [isIE, false, function x() { isIE = !window.opera; }];}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var isIE = true;  var isFF = false;  function x() { isIE = !window.opera; }  return [isIE, isFF, x];}")))));
    }

    public final void testAssignedInUnusedClosure() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  return [true, false];}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var isIE = true;  var isFF = false;  function x() { isIE = !window.opera; }  return [isIE, isFF];}")))));
    }

    public final void testDoubleInitialized() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  var isIE = true;  var isIE = isIE && !window.opera;  return [isIE, false];}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var isIE = true;  var isFF = false, isIE = isIE && !window.opera;  return [isIE, isFF];}")))));
    }

    public final void testMultiDecls() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  return [true, false];}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var isFF = false, isIE = true;  return [isIE, isFF];}")))));
    }

    public final void testUndefined() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  return [void 1, 'undefined', void 0];}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var x, x = void 1, y = 'undefined', z;  return [x, y, z];}")))));
    }

    public final void testUndeclared() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  return x;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  return x;}")))));
    }

    public final void testFunctionDeclarations() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  return function g() {};}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  function g() {}  return g;}")))));
    }

    public final void testFunctionMasking1() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  var g = 1;  function g() {}  return g;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var g = 1;  function g() {}  return g;}")))));
    }

    public final void testFunctionMasking2() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  function g() {}  var g = 1;  return g;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  function g() {}  var g = 1;  return g;}")))));
    }

    public final void testIdentityOfOutput() throws Exception {
        Block canOptimize = this.js(this.fromString("function f() {  var x = true;  return x;}"));
        Block cannotOptimize = this.js(this.fromString("function f() {  return true;}"));
        ConstLocalOptimizationTest.assertSame((Object)cannotOptimize, (Object)ConstLocalOptimization.optimize(cannotOptimize));
        Block optimized = ConstLocalOptimization.optimize(canOptimize);
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(cannotOptimize), (String)ConstLocalOptimizationTest.render(optimized));
        ConstLocalOptimizationTest.assertFalse((canOptimize == optimized ? 1 : 0) != 0);
        ConstLocalOptimizationTest.assertSame((Object)optimized, (Object)ConstLocalOptimization.optimize(optimized));
    }

    public final void testForEachLoop1() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  var lastKey = null;  for (lastKey in obj);  return lastKey;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var lastKey = null;  for (lastKey in obj);  return lastKey;}")))));
    }

    public final void testForEachLoop2() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  lastKey = null;  for (var lastKey in obj);  return lastKey;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  lastKey = null;  for (var lastKey in obj);  return lastKey;}")))));
    }

    public final void testUnusedFunctions() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  return 3;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  function g() { return 4; }  var i = 3;  return i;}")))));
    }

    public final void testGlobalsNotEliminated() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("var x = true;function f() { alert('Hello World!'); }alert(x);"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("var x = true;function f() { alert('Hello World!'); }alert(x);")))));
    }

    public final void testSinglyUsedObjects() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f(x) {  var obj2 = { 1: baz, 2: boo };  return (function g(y) { return obj2[y]; })      (({ foo: 1, bar: 2 })[x]);}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f(x) {  var obj1 = { foo: 1, bar: 2 };  var obj2 = { 1: baz, 2: boo };  function g(y) { return obj2[y]; }  return g(obj1[x]);}")))));
    }

    public final void testRedundantDecls() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f(x) {  return 1;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f(x) {  var x, x = 1, x;  return x;}")))));
    }

    public final void testNotInlineable() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  var x = y, y = 1;  return [x, 1, 2];}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var x = y, y = 1, z = 2;  return [x, y, z];}")))));
    }

    public final void testArguments() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  var arguments = 1;  return arguments[0];}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var arguments = 1;  return arguments[0];}")))));
    }

    public final void testLiteralsAcrossFunctionBoundaries() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function f() {  return function g() { return 4; };}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function f() {  var n = 4;  function g() { return n; }  return g;}")))));
    }

    public final void testCalls() throws Exception {
        ConstLocalOptimizationTest.assertEquals((String)ConstLocalOptimizationTest.render(this.js(this.fromString("function g() {  var y = (function f() { return z; })(), z = 2;  return 1 + y + 2;}"))), (String)ConstLocalOptimizationTest.render(ConstLocalOptimization.optimize(this.js(this.fromString("function g() {  var x = 1, y = f(), z = 2;  function f() { return z; }  return x + y + z;}")))));
    }
}

