/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import org.gatein.common.io.IOTools;
import org.gatein.common.io.UndeclaredIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalledObject<S extends Serializable> {
    private final ClassLoader loader;
    private final byte[] state;

    public static <S extends Serializable> MarshalledObject<S> marshall(S serializable) throws NullPointerException {
        if (serializable == null) {
            throw new NullPointerException("Cannot marshall null");
        }
        try {
            byte[] bytes = IOTools.serialize(serializable);
            return new MarshalledObject<S>(serializable.getClass().getClassLoader(), bytes);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    private MarshalledObject(ClassLoader loader, byte[] state) {
        this.loader = loader;
        this.state = state;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MarshalledObject) {
            MarshalledObject that = (MarshalledObject)obj;
            return Arrays.equals(this.state, that.state);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.state);
    }

    public S unmarshall() throws UndeclaredThrowableException {
        try {
            return (S)IOTools.unserialize((byte[])this.state, (ClassLoader)this.loader);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

