/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.io.Serializable;
import org.exoplatform.web.application.CompoundApplicationMessage;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MultipleConditionsValidator;

public class NumberFormatValidator
extends MultipleConditionsValidator
implements Serializable {
    protected void validate(String value, String label, CompoundApplicationMessage messages, UIFormInput uiInput) {
        this.validateInteger(value, label, messages);
    }

    protected Integer validateInteger(String value, String label, CompoundApplicationMessage messages) {
        Object[] args = new Object[]{label};
        if (value.charAt(0) == '0' && value.length() > 1) {
            messages.addMessage("NumberFormatValidator.msg.Invalid-number", args);
        } else if (value.charAt(0) == '-' && value.length() > 1 && value.charAt(1) == '0') {
            messages.addMessage("NumberFormatValidator.msg.Invalid-number", args);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            messages.addMessage("NumberFormatValidator.msg.Invalid-number", args);
            return null;
        }
    }
}

