/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.chromattic.api.RelationshipType;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.MappingVisitor;
import org.chromattic.metamodel.mapping.PropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipMapping<P extends PropertyInfo<BeanValueInfo, K>, R extends RelationshipMapping, K extends ValueKind>
extends PropertyMapping<P, BeanValueInfo, K> {
    final Class<R> relatedRelationhipType;
    private List<R> relatedRelationshipMapping;
    BeanMapping relatedBeanMapping;

    public RelationshipMapping(Class<R> relatedRelationhipType, P property) {
        super(property);
        this.relatedRelationhipType = relatedRelationhipType;
        this.relatedRelationshipMapping = null;
        this.relatedBeanMapping = null;
    }

    public BeanInfo getRelatedBean() {
        return ((BeanValueInfo)this.property.getValue()).getBean();
    }

    public BeanMapping getRelatedBeanMapping() {
        return this.relatedBeanMapping;
    }

    public List<R> getRelatedRelationshipMapping() {
        return this.relatedRelationshipMapping;
    }

    @Override
    public boolean isTypeCovariant() {
        if (this.parent == null) {
            return true;
        }
        RelationshipMapping parentRelationship = (RelationshipMapping)this.parent;
        return ((BeanValueInfo)this.property.getValue()).getBean() != ((BeanValueInfo)parentRelationship.property.getValue()).getBean();
    }

    void resolve() {
        if (this.relatedRelationshipMapping != null) {
            return;
        }
        List found = Collections.emptyList();
        for (PropertyMapping<?, ?, ?> relatedBeanPropertyMapping : this.relatedBeanMapping.getProperties().values()) {
            RelationshipMapping toRelationship;
            RelationshipMapping relatedBeanRelationshipMapping;
            if (!(relatedBeanPropertyMapping instanceof RelationshipMapping) || !this.relatedRelationhipType.isInstance(relatedBeanRelationshipMapping = (RelationshipMapping)relatedBeanPropertyMapping) || this == (toRelationship = (RelationshipMapping)this.relatedRelationhipType.cast(relatedBeanRelationshipMapping)) || !this.matches(toRelationship)) continue;
            if (found.isEmpty()) {
                found = new LinkedList();
            }
            found.add(toRelationship);
        }
        this.relatedRelationshipMapping = found;
    }

    abstract boolean matches(R var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class OneToMany<R extends ManyToOne, K extends ValueKind.Multi>
    extends RelationshipMapping<PropertyInfo<BeanValueInfo, K>, R, K> {
        protected OneToMany(Class<R> relatedRelationhipType, PropertyInfo<BeanValueInfo, K> property) {
            super(relatedRelationhipType, property);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Reference<K extends ValueKind.Multi>
        extends OneToMany<ManyToOne.Reference, K> {
            final String mappedBy;
            final RelationshipType type;

            public Reference(PropertyInfo<BeanValueInfo, K> property, String mappedBy, RelationshipType type) {
                super(ManyToOne.Reference.class, property);
                this.mappedBy = mappedBy;
                this.type = type;
            }

            public String getMappedBy() {
                return this.mappedBy;
            }

            public RelationshipType getType() {
                return this.type;
            }

            @Override
            public void accept(MappingVisitor visitor) {
                visitor.oneToManyReference(this);
            }

            @Override
            public boolean matches(ManyToOne.Reference relationship) {
                return this.mappedBy.equals(relationship.mappedBy);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Hierarchic<K extends ValueKind.Multi>
        extends OneToMany<ManyToOne.Hierarchic, K> {
            final String declaredPrefix;
            final String prefix;

            public Hierarchic(PropertyInfo<BeanValueInfo, K> property, String declaredPrefix, String prefix) {
                super(ManyToOne.Hierarchic.class, property);
                this.declaredPrefix = declaredPrefix;
                this.prefix = prefix;
            }

            public String getDeclaredPrefix() {
                return this.declaredPrefix;
            }

            public String getPrefix() {
                return this.prefix;
            }

            @Override
            public void accept(MappingVisitor visitor) {
                visitor.oneToManyHierarchic(this);
            }

            @Override
            public boolean matches(ManyToOne.Hierarchic relationship) {
                return true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ManyToOne<R extends OneToMany>
    extends RelationshipMapping<PropertyInfo<BeanValueInfo, ValueKind.Single>, R, ValueKind.Single> {
        protected ManyToOne(Class<R> relatedRelationhipType, PropertyInfo<BeanValueInfo, ValueKind.Single> property) {
            super(relatedRelationhipType, property);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Reference
        extends ManyToOne<OneToMany.Reference> {
            final String mappedBy;
            final RelationshipType type;

            public Reference(PropertyInfo<BeanValueInfo, ValueKind.Single> property, String mappedBy, RelationshipType type) {
                super(OneToMany.Reference.class, property);
                this.mappedBy = mappedBy;
                this.type = type;
            }

            public String getMappedBy() {
                return this.mappedBy;
            }

            public RelationshipType getType() {
                return this.type;
            }

            @Override
            public void accept(MappingVisitor visitor) {
                visitor.manyToOneReference(this);
            }

            @Override
            public boolean matches(OneToMany.Reference relationship) {
                return this.mappedBy.equals(relationship.mappedBy);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Hierarchic
        extends ManyToOne<OneToMany.Hierarchic> {
            final String declaredPrefix;
            final String prefix;

            public Hierarchic(PropertyInfo<BeanValueInfo, ValueKind.Single> property, String declaredPrefix, String prefix) {
                super(OneToMany.Hierarchic.class, property);
                this.declaredPrefix = declaredPrefix;
                this.prefix = prefix;
            }

            public String getDeclaredPrefix() {
                return this.declaredPrefix;
            }

            public String getPrefix() {
                return this.prefix;
            }

            @Override
            public void accept(MappingVisitor visitor) {
                visitor.manyToOneHierarchic(this);
            }

            @Override
            public boolean matches(OneToMany.Hierarchic relationship) {
                return true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class OneToOne<R extends OneToOne>
    extends RelationshipMapping<PropertyInfo<BeanValueInfo, ValueKind.Single>, R, ValueKind.Single> {
        final boolean owner;

        protected OneToOne(Class<R> relatedRelationhipType, PropertyInfo<BeanValueInfo, ValueKind.Single> property, boolean owner) {
            super(relatedRelationhipType, property);
            this.owner = owner;
        }

        public boolean isOwner() {
            return this.owner;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Embedded
        extends OneToOne<Embedded> {
            public Embedded(PropertyInfo<BeanValueInfo, ValueKind.Single> property, boolean owner) {
                super(Embedded.class, property, owner);
            }

            @Override
            public void accept(MappingVisitor visitor) {
                visitor.oneToOneEmbedded(this);
            }

            @Override
            public boolean matches(Embedded relationship) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Hierarchic
        extends OneToOne<Hierarchic> {
            final String declaredPrefix;
            final String prefix;
            final String localName;
            final boolean mandatory;
            final boolean autocreated;

            public Hierarchic(PropertyInfo<BeanValueInfo, ValueKind.Single> property, boolean owner, String declaredPrefix, String prefix, String localName, boolean mandatory, boolean autocreated) {
                super(Hierarchic.class, property, owner);
                this.declaredPrefix = declaredPrefix;
                this.prefix = prefix;
                this.localName = localName;
                this.mandatory = mandatory;
                this.autocreated = autocreated;
            }

            public boolean getMandatory() {
                return this.mandatory;
            }

            public boolean getAutocreated() {
                return this.autocreated;
            }

            public String getDeclaredPrefix() {
                return this.declaredPrefix;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public String getLocalName() {
                return this.localName;
            }

            @Override
            public void accept(MappingVisitor visitor) {
                visitor.oneToOneHierarchic(this);
            }

            @Override
            public boolean matches(Hierarchic relationship) {
                String fromPrefix = this.prefix == null ? "" : this.prefix;
                String toPrefix = relationship.prefix == null ? "" : relationship.prefix;
                return fromPrefix.equals(toPrefix) && this.localName.equals(relationship.localName) && this.owner != relationship.owner;
            }
        }
    }
}

