/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.crsh.util.FutureListener;

public class LatchedFuture<V>
implements Future<V> {
    private V value = null;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Lock lock = new ReentrantLock();
    private FutureListener<V> listener;

    public LatchedFuture() {
    }

    public LatchedFuture(V value) {
        this.set(value);
    }

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.value;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(l, timeUnit);
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FutureListener<V> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            if (this.listener != null) {
                throw new IllegalStateException();
            }
            this.listener = listener;
            if (this.latch.getCount() == 0L) {
                listener.completed(this.value);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(V value) {
        block5: {
            this.lock.lock();
            try {
                if (this.latch.getCount() > 0L) {
                    this.value = value;
                    this.latch.countDown();
                    if (this.listener != null) {
                        this.listener.completed(value);
                    }
                    break block5;
                }
                throw new IllegalStateException();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

