/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import java.util.Map;

class SyntheticRuleSet {
    SyntheticRuleSet() {
    }

    public static Rule[] syntheticRules(final Rewriter rw) {
        return new Rule[]{new Rule(){

            @RuleDescription(name="syntheticReference", synopsis="Pass through synthetic references.", reason="A variable may not be mentionable otherwise.", matches="/* synthetic */ @ref", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Reference ref;
                if (node instanceof Reference && 1.isSynthetic((ref = (Reference)node).getIdentifier())) {
                    return rw.noexpand((Reference)node);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticCalls", synopsis="Pass through calls where the function name is synthetic.", reason="A synthetic method may not be marked callable.", matches="/* synthetic */ @f(@as*)", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Expression f;
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null && (f = (Expression)bindings.get("f")) instanceof Reference && 2.isSynthetic((Reference)f)) {
                    return this.expandAll(node, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticMethodCalls", synopsis="Pass through calls where the method name is synthetic.", reason="A synthetic method may not be marked callable.", matches="/* synthetic */ @o.@m(@as*)", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null && 3.isSynthetic((Reference)bindings.get("m"))) {
                    return this.expandAll(node, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticDeletes", synopsis="Pass through deletes of synthetic members.", reason="A synthetic member may not be marked deletable.", matches="/* synthetic */ delete @o.@m", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null && 4.isSynthetic((Reference)bindings.get("m"))) {
                    return this.expandAll(node, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticReads", synopsis="Pass through reads of synthetic members.", reason="A synthetic member may not be marked readable.", matches="/* synthetic */ @o.@m", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null && 5.isSynthetic((Reference)bindings.get("m"))) {
                    return this.expandAll(node, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticSetMember", synopsis="Pass through sets of synthetic members.", reason="A synthetic member may not be marked writable.", matches="/* synthetic */ @o.@m = @v", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null && 6.isSynthetic((Reference)bindings.get("m"))) {
                    return this.expandAll(node, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticSetVar", synopsis="Pass through set of synthetic vars.", reason="A local variable might not be mentionable otherwise.", matches="/* synthetic */ @lhs = @rhs", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null && bindings.get("lhs") instanceof Reference && 7.isSynthetic((Reference)bindings.get("lhs"))) {
                    return this.expandAll(node, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticDeclaration", synopsis="Pass through synthetic variables which are unmentionable.", reason="Synthetic code might need local variables for safe-keeping.", matches="/* synthetic */ var @v = @initial?;", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null && 8.isSynthetic((Identifier)bindings.get("v"))) {
                    AbstractStatement s;
                    Declaration d = (Declaration)this.expandAll(node, scope);
                    if (d.getInitializer() == null) {
                        s = new Noop(d.getFilePosition());
                    } else {
                        s = new ExpressionStmt(Operation.createInfix(Operator.ASSIGN, new Reference(d.getIdentifier()), d.getInitializer()));
                        Scope.markForSideEffect(s);
                        d.removeChild(d.getInitializer());
                    }
                    scope.addStartOfScopeStatement(d);
                    return s;
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticFormals", synopsis="Pass through synthetic formals which are unmentionable.", reason="Synthetic code might need local variables for safe-keeping.", matches="/* synthetic */ @x in a parameter list", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                if (node instanceof FormalParam && 9.isSynthetic(((FormalParam)node).getIdentifier())) {
                    return this.expandAll(node, scope);
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticFnDeclaration", synopsis="Allow declaration of synthetic functions.", reason="Synthetic functions allow generated code to avoid introducing unnecessary scopes.", matches="/* synthetic */ function @i?(@actuals*) { @body* }", substitutes="<expanded>")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                FunctionConstructor ctor;
                FunctionConstructor functionConstructor = ctor = node instanceof FunctionDeclaration ? ((FunctionDeclaration)node).getInitializer() : (FunctionConstructor)node;
                if (10.isSynthetic(ctor)) {
                    Scope newScope = Scope.fromFunctionConstructor(scope, ctor);
                    ParseTreeNode result = this.expandAll(node, newScope);
                    for (Statement s : newScope.getStartStatements()) {
                        scope.addStartStatement(s);
                    }
                    return result;
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticCatches1", synopsis="Pass through synthetic variables which are unmentionable.", reason="Catching unmentionable exceptions helps maintain invariants.", matches="try { @body*; } catch (/* synthetic */ @ex___) { @handler*; }", substitutes="try { @body*; } catch (@ex___) { @handler*; }")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null) {
                    Identifier ex = (Identifier)bindings.get("ex");
                    TryStmt ts = (TryStmt)node;
                    CatchStmt cs = ts.getCatchClause();
                    if (11.isSynthetic(ex)) {
                        return this.substV("body", rw.expand(bindings.get("body"), scope), "ex", rw.noexpand(ex), "handler", rw.expand(bindings.get("handler"), Scope.fromCatchStmt(scope, cs)));
                    }
                }
                return NONE;
            }
        }, new Rule(){

            @RuleDescription(name="syntheticCatches2", synopsis="Pass through synthetic variables which are unmentionable.", reason="Catching unmentionable exceptions helps maintain invariants.", matches="try { @body*; } catch (/* synthetic */ @ex___) { @handler*; } finally { @cleanup*; }", substitutes="try { @body*; } catch (/* synthetic */ @ex___) { @handler*; } finally { @cleanup*; }")
            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                Map<String, ParseTreeNode> bindings = this.match(node);
                if (bindings != null) {
                    TryStmt ts = (TryStmt)node;
                    CatchStmt cs = ts.getCatchClause();
                    Identifier ex = (Identifier)bindings.get("ex");
                    if (12.isSynthetic(ex)) {
                        return this.substV("body", rw.expand(bindings.get("body"), scope), "ex", rw.noexpand(ex), "handler", rw.expand(bindings.get("handler"), Scope.fromCatchStmt(scope, cs)), "cleanup", rw.expand(bindings.get("cleanup"), scope));
                    }
                }
                return NONE;
            }
        }};
    }
}

