/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.SearchId;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.Util;
import tcl.lang.Var;

class ArrayCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"anymore", "donesearch", "exists", "get", "names", "nextelement", "set", "size", "startsearch"};
    static final int OPT_ANYMORE = 0;
    static final int OPT_DONESEARCH = 1;
    static final int OPT_EXISTS = 2;
    static final int OPT_GET = 3;
    static final int OPT_NAMES = 4;
    static final int OPT_NEXTELEMENT = 5;
    static final int OPT_SET = 6;
    static final int OPT_SIZE = 7;
    static final int OPT_STARTSEARCH = 8;

    ArrayCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        Var var = null;
        Var var2 = null;
        boolean bl = false;
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arrayName ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        String string2 = tclObjectArray[2].toString();
        Var[] varArray = Var.lookupVar(interp, string2, null, 0, null, false, false);
        if (varArray != null) {
            var = varArray[0];
            var2 = varArray[1];
        }
        if (var == null || !var.isVarArray() || var.isVarUndefined()) {
            bl = true;
        }
        if (var != null && var.traces != null && (string = Var.callTraces(interp, var2, var, string2, null, 2563)) != null) {
            throw new TclVarException(interp, string2, null, "trace array", string);
        }
        switch (n) {
            case 0: {
                Enumeration enumeration;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName searchId");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if ((enumeration = var.getSearch(tclObjectArray[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if (enumeration.hasMoreElements()) {
                    interp.setResult("1");
                    break;
                }
                interp.setResult("0");
                break;
            }
            case 1: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName searchId");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                boolean bl2 = true;
                if (var.sidVec != null) {
                    bl2 = var.removeSearch(tclObjectArray[3].toString());
                }
                if (var.sidVec != null && bl2) break;
                ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                break;
            }
            case 2: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName");
                }
                interp.setResult(!bl);
                break;
            }
            case 3: {
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName ?pattern?");
                }
                if (bl) {
                    return;
                }
                String string3 = null;
                if (tclObjectArray.length == 4) {
                    string3 = tclObjectArray[3].toString();
                }
                Hashtable hashtable = (Hashtable)var.value;
                TclObject tclObject = TclList.newInstance();
                String string4 = tclObjectArray[2].toString();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    Var var3 = (Var)hashtable.get(string5);
                    if (var3.isVarUndefined() || string3 != null && !Util.stringMatch(string5, string3)) continue;
                    String string6 = interp.getVar(string4, string5, 0).toString();
                    TclList.append(interp, tclObject, TclString.newInstance(string5));
                    TclList.append(interp, tclObject, TclString.newInstance(string6));
                }
                interp.setResult(tclObject);
                break;
            }
            case 4: {
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName ?pattern?");
                }
                if (bl) {
                    return;
                }
                String string7 = null;
                if (tclObjectArray.length == 4) {
                    string7 = tclObjectArray[3].toString();
                }
                Hashtable hashtable = (Hashtable)var.value;
                TclObject tclObject = TclList.newInstance();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string8 = (String)enumeration.nextElement();
                    Var var4 = (Var)hashtable.get(string8);
                    if (var4.isVarUndefined() || string7 != null && !Util.stringMatch(string8, string7)) continue;
                    TclList.append(interp, tclObject, TclString.newInstance(string8));
                }
                interp.setResult(tclObject);
                break;
            }
            case 5: {
                Enumeration enumeration;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName searchId");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if ((enumeration = var.getSearch(tclObjectArray[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if (!enumeration.hasMoreElements()) break;
                Hashtable hashtable = (Hashtable)var.value;
                String string9 = (String)enumeration.nextElement();
                Var var5 = (Var)hashtable.get(string9);
                if ((var5.flags & 8) == 0) {
                    interp.setResult(string9);
                    break;
                }
                interp.setResult("");
                break;
            }
            case 6: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName list");
                }
                int n2 = TclList.getLength(interp, tclObjectArray[3]);
                if (n2 % 2 != 0) {
                    throw new TclException(interp, "list must have an even number of elements");
                }
                String string10 = tclObjectArray[2].toString();
                int n3 = 0;
                while (n3 < n2) {
                    String string11 = TclList.index(interp, tclObjectArray[3], n3++).toString();
                    String string12 = TclList.index(interp, tclObjectArray[3], n3).toString();
                    interp.setVar(string10, string11, TclString.newInstance(string12), 0);
                    ++n3;
                }
                break;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName");
                }
                if (bl) {
                    interp.setResult(0);
                    break;
                }
                Hashtable hashtable = (Hashtable)var.value;
                int n4 = 0;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Var var6 = (Var)hashtable.get((String)enumeration.nextElement());
                    if ((var6.flags & 8) != 0) continue;
                    ++n4;
                }
                interp.setResult(n4);
                break;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                if (var.sidVec == null) {
                    var.sidVec = new Vector();
                }
                int n5 = var.getNextIndex();
                String string13 = "s-" + n5 + "-" + tclObjectArray[2].toString();
                Enumeration enumeration = ((Hashtable)var.value).keys();
                var.sidVec.addElement(new SearchId(enumeration, string13, n5));
                interp.setResult(string13);
            }
        }
    }

    private static void errorNotArray(Interp interp, String string) throws TclException {
        throw new TclException(interp, "\"" + string + "\" isn't an array");
    }

    static void errorIllegalSearchId(Interp interp, String string, String string2) throws TclException {
        int n = ArrayCmd.validSearchId(string2.toCharArray(), string);
        if (n == 1) {
            throw new TclException(interp, "couldn't find search \"" + string2 + "\"");
        }
        if (n == 0) {
            throw new TclException(interp, "illegal search identifier \"" + string2 + "\"");
        }
        throw new TclException(interp, "search identifier \"" + string2 + "\" isn't for variable \"" + string + "\"");
    }

    private static int validSearchId(char[] cArray, String string) {
        if (cArray[0] != 's' || cArray[1] != '-' || cArray[2] < '0' || cArray[2] > '9') {
            return 0;
        }
        int n = 3;
        while (n < cArray.length && cArray[n] != '-') {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return 0;
            }
            ++n;
        }
        if (++n >= cArray.length) {
            return 0;
        }
        if (string.equals(new String(cArray, n, cArray.length - n))) {
            return 1;
        }
        return -1;
    }
}

