/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.StdChannel;
import tcl.lang.TclRuntimeError;

class TclIO {
    static final int READ_ALL = 1;
    static final int READ_LINE = 2;
    static final int READ_N_BYTES = 3;
    static final int SEEK_SET = 1;
    static final int SEEK_CUR = 2;
    static final int SEEK_END = 3;
    static final int RDONLY = 1;
    static final int WRONLY = 2;
    static final int RDWR = 4;
    static final int APPEND = 8;
    static final int CREAT = 16;
    private static StdChannel stdinChan = null;
    private static StdChannel stdoutChan = null;
    private static StdChannel stderrChan = null;

    TclIO() {
    }

    static Channel getChannel(Interp interp, String string) {
        Channel channel = null;
        if (string.length() > 0 && string.charAt(0) == 's') {
            if (string.equals("stdin")) {
                channel = TclIO.getStdChannel(0);
            } else if (string.equals("stdout")) {
                channel = TclIO.getStdChannel(1);
            } else if (string.equals("stderr")) {
                channel = TclIO.getStdChannel(2);
            }
            if (channel != null) {
                string = channel.getChanName();
            }
        }
        Hashtable hashtable = TclIO.getInterpChanTable(interp);
        return (Channel)hashtable.get(string);
    }

    static void registerChannel(Interp interp, Channel channel) {
        if (interp != null) {
            Hashtable hashtable = TclIO.getInterpChanTable(interp);
            hashtable.put(channel.getChanName(), channel);
        }
    }

    static void unregisterChannel(Interp interp, Channel channel) {
        Hashtable hashtable = TclIO.getInterpChanTable(interp);
        hashtable.remove(channel.getChanName());
    }

    static Hashtable getInterpChanTable(Interp interp) {
        if (interp.interpChanTable == null) {
            interp.interpChanTable = new Hashtable();
            Channel channel = TclIO.getStdChannel(0);
            TclIO.registerChannel(interp, channel);
            channel = TclIO.getStdChannel(1);
            TclIO.registerChannel(interp, channel);
            channel = TclIO.getStdChannel(2);
            TclIO.registerChannel(interp, channel);
        }
        return interp.interpChanTable;
    }

    static Channel getStdChannel(int n) {
        StdChannel stdChannel = null;
        switch (n) {
            case 0: {
                if (stdinChan == null) {
                    stdinChan = new StdChannel(0);
                }
                stdChannel = stdinChan;
                break;
            }
            case 1: {
                if (stdoutChan == null) {
                    stdoutChan = new StdChannel(1);
                }
                stdChannel = stdoutChan;
                break;
            }
            case 2: {
                if (stderrChan == null) {
                    stderrChan = new StdChannel(2);
                }
                stdChannel = stderrChan;
                break;
            }
            default: {
                throw new TclRuntimeError("Invalid type for StdChannel");
            }
        }
        return stdChannel;
    }
}

