/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import com.echomine.util.Semaphore;

public class FIFOSemaphore
extends Semaphore {
    protected WaitQueue queue = new WaitQueue();

    public FIFOSemaphore(long initial) {
        super(initial);
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaitNode node = null;
        FIFOSemaphore fIFOSemaphore = this;
        synchronized (fIFOSemaphore) {
            try {
                if (this.permits > 0L) {
                    --this.permits;
                    Object var5_3 = null;
                    return;
                }
                node = new WaitNode();
                this.queue.enq(node);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
        node.wait();
    }

    public void release() {
        WaitNode node;
        do {
            if ((node = this.queue.deq()) != null) continue;
            ++this.permits;
            return;
        } while (!node.doNotify());
    }

    protected static class WaitQueue {
        protected WaitNode head = null;
        protected WaitNode last = null;

        protected void enq(WaitNode node) {
            if (this.last == null) {
                this.head = this.last = node;
            } else {
                this.last.next = node;
                this.last = node;
            }
        }

        protected WaitNode deq() {
            WaitNode node = this.head;
            if (node != null) {
                this.head = node.next;
                if (this.head == null) {
                    this.last = null;
                }
                node.next = null;
            }
            return node;
        }

        protected WaitQueue() {
        }
    }

    protected static class WaitNode {
        boolean released = false;
        WaitNode next = null;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized void doWait() throws InterruptedException {
            try {
                while (!this.released) {
                    this.wait();
                }
                return;
            }
            catch (InterruptedException ex) {
                if (!this.released) {
                    this.released = true;
                    throw ex;
                }
                Thread.currentThread().interrupt();
            }
        }

        synchronized boolean doNotify() {
            if (this.released) {
                return false;
            }
            this.released = true;
            this.notify();
            return true;
        }

        synchronized boolean doTimedWait(long msecs) throws InterruptedException {
            return false;
        }

        protected WaitNode() {
        }
    }
}

