/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.editor.codemirror;

import java.util.HashMap;
import java.util.Iterator;

import org.exoplatform.gwtframework.commons.rest.MimeType;

import com.google.gwt.core.client.GWT;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class CodemirrorConfiguration
{

   private static final String DEFAULT_MIMETYPE = MimeType.TEXT_PLAIN;

   public static final String PATH = GWT.getModuleBaseURL() + "codemirror/";

   public static final String JS_DIRECTORY = PATH + "js/";

   private static HashMap<String, String> codeParsers = new HashMap<String, String>();

   private static HashMap<String, String> codeStyles = new HashMap<String, String>();

   static
   {
      codeParsers.put(MimeType.TEXT_PLAIN, "['parsexml.js', 'parsecss.js']");
      codeStyles.put(MimeType.TEXT_PLAIN, "['" + PATH + "css/xmlcolors.css']");

      codeParsers.put(MimeType.TEXT_XML, "['parsexml.js', 'tokenize.js']");
      codeStyles.put(MimeType.TEXT_XML, "['" + PATH + "css/xmlcolors.css']");

      codeParsers.put(MimeType.APPLICATION_XML, "['parsexml.js', 'tokenize.js']");
      codeStyles.put(MimeType.APPLICATION_XML, "['" + PATH + "css/xmlcolors.css']");

      codeParsers.put(MimeType.TEXT_CSS, "['parsecss.js']");
      codeStyles.put(MimeType.TEXT_CSS, "['" + PATH + "css/csscolors.css']");

      codeParsers.put(MimeType.TEXT_JAVASCRIPT, "['tokenizejavascript.js', 'parsejavascript.js']");
      codeStyles.put(MimeType.TEXT_JAVASCRIPT, "['" + PATH + "css/jscolors.css']");

      codeParsers.put(MimeType.APPLICATION_JAVASCRIPT, "['tokenizejavascript.js', 'parsejavascript.js']");
      codeStyles.put(MimeType.APPLICATION_JAVASCRIPT, "['" + PATH + "css/jscolors.css']");

      codeParsers.put(MimeType.APPLICATION_X_JAVASCRIPT, "['tokenizejavascript.js', 'parsejavascript.js']");
      codeStyles.put(MimeType.APPLICATION_X_JAVASCRIPT, "['" + PATH + "css/jscolors.css']");

      codeParsers.put(MimeType.TEXT_HTML,
         "['parsexml.js', 'parsecss.js', 'tokenizejavascript.js', 'parsejavascript.js', 'parsehtmlmixed.js']");
      codeStyles.put(MimeType.TEXT_HTML, "['" + PATH + "css/xmlcolors.css', '" + PATH + "css/jscolors.css', '" + PATH
         + "css/csscolors.css']");
      
      
      codeParsers.put(MimeType.GROOVY_SERVICE, "['parsegroovy.js', 'tokenizegroovy.js']");
      codeStyles.put(MimeType.GROOVY_SERVICE, "['" + PATH + "css/groovycolors.css']");      
      
      codeParsers.put(MimeType.APPLICATION_GROOVY, "['parsegroovy.js', 'tokenizegroovy.js']");
      codeStyles.put(MimeType.APPLICATION_GROOVY, "['" + PATH + "css/groovycolors.css']");

      codeParsers.put(MimeType.GOOGLE_GADGET,
         "['parsegadgetxml.js', 'parsecss.js', 'tokenizejavascript.js', 'parsejavascript.js', 'parsehtmlmixed.js']");
      codeStyles.put(MimeType.GOOGLE_GADGET, "['" + PATH + "css/xmlcolors.css', '" + PATH + "css/jscolors.css', '"
         + PATH + "css/csscolors.css']");
      
//      codeParsers.put(MimeType.UWA_WIDGET, "['parsexml.js', 'parsecss.js', 'tokenizejavascript.js', 'parsejavascript.js', 'parsehtmlmixed.js']");
//      codeStyles.put(MimeType.UWA_WIDGET, "['" + PATH + "css/xmlcolors.css', '" + PATH + "css/jscolors.css', '" + PATH + "css/csscolors.css']");
         
      codeParsers.put(MimeType.GROOVY_TEMPLATE, "['parsegtmpl.js', 'parsecss.js', 'tokenizejavascript.js', 'parsejavascript.js', 'tokenizegroovy.js', 'parsegroovy.js', 'parsegtmplmixed.js']");           
      codeStyles.put(MimeType.GROOVY_TEMPLATE, "['" + PATH + "css/gtmplcolors.css', '" + PATH + "css/jscolors.css', '" + PATH + "css/csscolors.css', '" + PATH + "css/groovycolors.css']");
   }

   /**
    * 0 to turn off continuous scanning, or value like 100 in millisec as scanning period
    */
   public static final int CONTINUOUS_SCANNING = 0;

   public static final boolean TEXT_WRAPPING = false;

   public static String getStyleUrl(String mimeType)
   {
      Iterator<String> keys = codeStyles.keySet().iterator();
      while (keys.hasNext())
      {
         String key = keys.next();
         if (mimeType.equals(key))
         {
            return codeStyles.get(key);
         }
      }

      return codeStyles.get(DEFAULT_MIMETYPE);
   }

   public static String getParserNames(String mimeType)
   {
      Iterator<String> keys = codeParsers.keySet().iterator();
      while (keys.hasNext())
      {
         String key = keys.next();
         if (mimeType.equals(key))
         {
            return codeParsers.get(key);
         }
      }

      return codeParsers.get(DEFAULT_MIMETYPE);
   }

}
