/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.editor.fckeditor;

import org.exoplatform.gwtframework.editor.api.Editor;
import org.exoplatform.gwtframework.editor.api.EditorConfiguration;

import com.google.gwt.event.shared.HandlerManager;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class FCKEditorProducer implements Editor
{

   private static final String DESCRIPTION = "WYSWYG Editor";

   private String mimeType;

   private boolean isDefaultEditor;

   public FCKEditorProducer(String mimeType)
   {
      this.mimeType = mimeType;
   }

   public String getDescription()
   {
      return DESCRIPTION;
   }

   public FCKEditor createTextEditor(HandlerManager eventBus, EditorConfiguration editorConfiguration)
   {
      editorConfiguration.setMimeType(mimeType);
      return new FCKEditor(eventBus, editorConfiguration);
   }

   public boolean isDefaultEditor()
   {
      return isDefaultEditor;
   }

   public void setIsDefaultEditor(boolean isDefaultEditor)
   {
      this.isDefaultEditor = isDefaultEditor;
   }

}
