/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client;

import org.exoplatform.gwtframework.ui.client.showcase.ShowcaseTreeNavigation;
import org.exoplatform.gwtframework.ui.client.showcase.cases.StatusBarCase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.TreeShowcase;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ShowCase implements EntryPoint, ShowCasePanel
{

   private Grid grid;

   public void onModuleLoad()
   {
      grid = new Grid(1, 2);
      DOM.setStyleAttribute(grid.getElement(), "width", "100%");
      DOM.setStyleAttribute(grid.getElement(), "height", "100%");
      DOM.setStyleAttribute(grid.getElement(), "background", "#ffffff");
      grid.setBorderWidth(0);

      DOM.setStyleAttribute(grid.getCellFormatter().getElement(0, 0), "width", "200px");

      grid.setHTML(0, 1, "&nbsp;");
      DOM.setStyleAttribute(grid.getCellFormatter().getElement(0, 1), "verticalAlign", "top");

      ShowcaseTreeNavigation navigation = new ShowcaseTreeNavigation(this);
      grid.setWidget(0, 0, navigation);

      RootPanel.get().add(grid);
      
//      new Timer()
//      {
//         @Override
//         public void run()
//         {
//            disableSelection();
//         }
//      }.schedule(1000);
   }

//   private static native void disableSelection() /*-{
//       $wnd.testFunction();
//    }-*/;

   public void showStatusBarCase()
   {
      grid.clearCell(0, 1);
      StatusBarCase statusBar = new StatusBarCase();
      grid.setWidget(0, 1, statusBar);
   }

   public void showTreeCase()
   {
      grid.clearCell(0, 1);
      TreeShowcase tree = new TreeShowcase();
      grid.setWidget(0, 1, tree);
   }

   public void showCase(Widget widget)
   {
      grid.clearCell(0, 1);
      grid.setWidget(0, 1, widget);
   }

}
