/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.command;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class SimpleControl extends Control
{

   private String title;

   private boolean showInMenu;

   private boolean showInContextMenu;

   private boolean canBeSelected;

   private boolean selected;

   /**
    * If true, then this command will call by hotkey, 
    * even if it will be disabled.
    */
   private boolean ignoreDisable;

   private GwtEvent<?> event;

   public SimpleControl(String id)
   {
      super(id);
   }

   /*
    * TITLE
    */

   public String getTitle()
   {
      return title;
   }

   public void setTitle(String title)
   {
      if (this.title == title)
      {
         return;
      }

      this.title = title;
      for (ControlStateListener listener : getStateListeners())
      {
         if (!(listener instanceof SimpleControlStateListener))
         {
            continue;
         }

         ((SimpleControlStateListener)listener).updateControlTitle(title);
      }
   }

   /*
    * SHOW IN MENU
    */

   public boolean isShowInMenu()
   {
      return showInMenu;
   }

   public void setShowInMenu(boolean showInMenu)
   {
      this.showInMenu = showInMenu;
   }

   /*
    * SHOW IN CONTEXT MENU
    */

   public boolean isShowInContextMenu()
   {
      return showInContextMenu;
   }

   public void setShowInContextMenu(boolean showInContextMenu)
   {
      this.showInContextMenu = showInContextMenu;
   }

   /*
    * CALL BY HOTKEY AND IGNORE DISABLE
    */

   public boolean isIgnoreDisable()
   {
      return ignoreDisable;
   }

   public void setIgnoreDisable(boolean ignoreDisable)
   {
      this.ignoreDisable = ignoreDisable;
   }

   /*
    * EVENT
    */

   public GwtEvent<?> getEvent()
   {
      return event;
   }

   public void setEvent(GwtEvent<?> event)
   {
      this.event = event;
   }

   public boolean canBeSelected()
   {
      return canBeSelected;
   }

   public void setCanBeSelected(boolean canBeSelected)
   {
      this.canBeSelected = canBeSelected;
   }

   public boolean isSelected()
   {
      return selected;
   }

   public void setSelected(boolean selected)
   {
      if (this.selected == selected)
      {
         return;
      }

      this.selected = selected;

      for (ControlStateListener listener : getStateListeners())
      {
         if (!(listener instanceof SimpleControlStateListener))
         {
            continue;
         }

         ((SimpleControlStateListener)listener).updateControlSelectionState(selected);
      }

   }

}
