/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.command.builder;

import org.exoplatform.gwtframework.ui.client.component.command.PopupMenuControl;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;

import com.google.gwt.resources.client.ImageResource;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class PopupMenuCommandBuilder
{

   private PopupMenuControl command;

   protected PopupMenuCommandBuilder(PopupMenuControl command)
   {
      this.command = command;
   }

   public static PopupMenuCommandBuilder newCommand(String id)
   {
      return new PopupMenuCommandBuilder(new PopupMenuControl(id));
   }

   public PopupMenuControl create()
   {
      return command;
   }

   public PopupMenuCommandBuilder addCommand(SimpleControl simpleCommand)
   {
      command.getCommands().add(simpleCommand);
      return this;
   }

   public PopupMenuCommandBuilder icon(String icon)
   {
      command.setIcon(icon);
      return this;
   }

   public PopupMenuCommandBuilder images(ImageResource normalImage, ImageResource disabledImage)
   {
      command.setNormalImage(normalImage);
      command.setDisabledImage(disabledImage);
      return this;
   }

   public PopupMenuCommandBuilder prompt(String prompt)
   {
      command.setPrompt(prompt);
      return this;
   }

   public PopupMenuCommandBuilder enable()
   {
      command.setEnabled(true);
      return this;
   }

   public PopupMenuCommandBuilder disable()
   {
      command.setEnabled(false);
      return this;
   }

   public PopupMenuCommandBuilder show()
   {
      command.setVisible(true);
      return this;
   }

   public PopupMenuCommandBuilder hide()
   {
      command.setVisible(false);
      return this;
   }

   public PopupMenuCommandBuilder setDelimiterBefore()
   {
      command.setDelimiterBefore(true);
      return this;
   }

   public PopupMenuCommandBuilder clearDelimiterBefore()
   {
      command.setDelimiterBefore(false);
      return this;
   }

}
