/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.command.builder;

import org.exoplatform.gwtframework.ui.client.component.command.TextEnteredEvent;
import org.exoplatform.gwtframework.ui.client.component.command.TextInputControl;

import com.google.gwt.resources.client.ImageResource;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class TextInputCommandBuilder
{

   private TextInputControl command;

   protected TextInputCommandBuilder(TextInputControl command)
   {
      this.command = command;
   }

   public static TextInputCommandBuilder newCommand(String id)
   {
      return new TextInputCommandBuilder(new TextInputControl(id));
   }

   public TextInputControl create()
   {
      return command;
   }

   public TextInputCommandBuilder icon(String icon)
   {
      command.setIcon(icon);
      return this;
   }
   
   public TextInputCommandBuilder images(ImageResource normalImage, ImageResource disabledImage) 
   {
      command.setNormalImage(normalImage);
      command.setDisabledImage(disabledImage);
      return this;
   }

   public TextInputCommandBuilder prompt(String prompt)
   {
      command.setPrompt(prompt);
      return this;
   }

   public TextInputCommandBuilder enable()
   {
      command.setEnabled(true);
      return this;
   }

   public TextInputCommandBuilder disable()
   {
      command.setEnabled(false);
      return this;
   }

   public TextInputCommandBuilder show()
   {
      command.setVisible(true);
      return this;
   }

   public TextInputCommandBuilder hide()
   {
      command.setVisible(false);
      return this;
   }

   public TextInputCommandBuilder setDelimiterBefore()
   {
      command.setDelimiterBefore(true);
      return this;
   }

   public TextInputCommandBuilder clearDelimiterBefore()
   {
      command.setDelimiterBefore(false);
      return this;
   }

   public TextInputCommandBuilder size(int size)
   {
      command.setSize(size);
      return this;
   }

   public TextInputCommandBuilder text(String text)
   {
      command.setText(text);
      return this;
   }

   public TextInputCommandBuilder event(TextEnteredEvent<?> event)
   {
      command.setEvent(event);
      return this;
   }

}
