/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.menu.bean;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControlStateListener;

import com.google.gwt.user.client.Element;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class CommandItem implements MenuItem, SimpleControlStateListener, MenuItemStateListener
{

   private String title;

   private SimpleControl control;

   private List<MenuItem> children = new ArrayList<MenuItem>();

   private MenuItemStateListener menuItemStateListener;

   public CommandItem(String title, MenuItemStateListener menuItemStateListener)
   {
      this.title = title;
      this.menuItemStateListener = menuItemStateListener;
   }

   public CommandItem(SimpleControl command, MenuItemStateListener menuItemStateListener)
   {
      title = command.getTitle();
      this.control = command;
      this.menuItemStateListener = menuItemStateListener;
      if (command != null)
      {
         command.getStateListeners().add(this);
      }
   }
   
   public String getTitle()
   {
      return title;
   }

   public List<MenuItem> getChildren()
   {
      return children;
   }

   public void initElement(Element element)
   {
   }

   public SimpleControl getCommand()
   {
      return control;
   }

   public void updateControlEnabling(boolean enabled)
   {
      menuItemStateListener.updateMenuItemState();
   }

   public void updateCommandSelectedState(boolean selected)
   {
   }

   public void updateControlVisibility(boolean visible)
   {
      menuItemStateListener.updateMenuItemState();
   }

   public void updateMenuItemState()
   {
      menuItemStateListener.updateMenuItemState();
   }

   public void updateControlPrompt(String prompt)
   {
   }

   public void updateControlIcon(String icon)
   {
   }

   public void updateControlTitle(String title)
   {
      this.title = title;
   }

   public void updateControlSelectionState(boolean selected)
   {
      // TODO Auto-generated method stub
      
   }

}
