/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.menu.bean;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.ui.client.component.command.ControlStateListener;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.menu.GWTMenuBar;
import org.exoplatform.gwtframework.ui.client.component.menu.style.MenuBarStyle;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class MenuBarItem implements MenuItem, ControlStateListener, MenuItemStateListener
{

   private String title;

   private SimpleControl command;

   protected List<MenuItem> children = new ArrayList<MenuItem>();

   private Element element;

   public MenuBarItem(String title, SimpleControl command)
   {
      this.title = title;
      this.command = command;
   }

   public List<MenuItem> getChildren()
   {
      return children;
   }

   public void initElement(Element element)
   {
      this.element = element;
      if (command != null)
      {
         command.getStateListeners().add(this);
      }

      boolean enabled = command == null ? true : command.isEnabled();

      if (enabled)
      {
         element.setClassName(MenuBarStyle.ITEM);
      }
      else
      {
         element.setClassName(MenuBarStyle.ITEM_DISABLED);
      }

      DOM.setElementAttribute(element, GWTMenuBar.TITLE_PROPERTY, title);
      DOM.setElementAttribute(element, GWTMenuBar.ENABLED_PROPERTY, "" + enabled);
   }

   public void updateControlEnabling(boolean enabled)
   {
      element.setClassName(enabled ? MenuBarStyle.ITEM : MenuBarStyle.ITEM_DISABLED);
      DOM.setElementAttribute(element, GWTMenuBar.ENABLED_PROPERTY, "" + enabled);
   }

   public void updateControlVisibility(boolean visible)
   {
   }

   public void updateCommandSelectedState(boolean selected)
   {
   }

   public void updateMenuItemState()
   {
      boolean enabled = getPopupItemsState(children);
      updateControlEnabling(enabled);
   }

   /**
    * Calculating the count of visible children in menu bar item
    * 
    * @param menuItems
    * @return
    */
   private boolean getPopupItemsState(List<MenuItem> menuItems)
   {
      int allItems = 0;
      int visibleItems = 0;

      for (MenuItem menuItem : menuItems)
      {
         if (menuItem instanceof CommandItem)
         {
            allItems++;
            CommandItem commandItem = (CommandItem)menuItem;
            if (commandItem.getCommand() == null || commandItem.getCommand().isVisible())
            {
               visibleItems++;
            }
         }
      }

      return visibleItems > 0;
   }

   public void updateControlPrompt(String prompt)
   {
   }

   public void updateControlIcon(String icon)
   {
   }

}
