/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.statusbar;

import java.util.List;

import org.exoplatform.gwtframework.ui.client.component.ExoStyle;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.LoaderControl;
import org.exoplatform.gwtframework.ui.client.component.command.StatusTextControl;
import org.exoplatform.gwtframework.ui.client.component.statusbar.component.StatusBarLoaderControl;
import org.exoplatform.gwtframework.ui.client.component.statusbar.component.StatusBarTextControl;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class GWTStatusBarForm extends Composite implements GWTStatusBarPresenter.Display
{

   public interface Style
   {

      public static final String PANEL = "exo-statusBar-panel";

      public static final String TABLE = "exo-statusBar-table";

      public static final String STATUSBAR_SPACER = "exo-statusBar-table-spacer-image";

      public static final String STATUSBAR_ELEMENT = "exo-statusBar-element";

   }

   private FlowPanel statusBarPanel;

   private HandlerManager eventBus;

   private GWTStatusBarPresenter presenter;

   private Grid statusBarGrid;

   public GWTStatusBarForm(HandlerManager eventBus)
   {
      this.eventBus = eventBus;

      statusBarPanel = new FlowPanel();
      initWidget(statusBarPanel);
      statusBarPanel.setStyleName(Style.PANEL);

      statusBarGrid = new Grid();
      statusBarGrid.setStyleName(Style.TABLE);
      statusBarGrid.setBorderWidth(0);
      statusBarGrid.setCellPadding(0);
      statusBarGrid.setCellSpacing(0);
      statusBarPanel.add(statusBarGrid);

      presenter = new GWTStatusBarPresenter(eventBus);
      presenter.bindDisplay(this);
   }

   /**
    * Update the Status Bar state
    * 
    * @see org.exoplatform.gwtframework.ui.client.component.statusbar.GWTStatusBarPresenter.Display#updateStatusBar(java.util.List)
    */
   public void updateStatusBar(List<Control> controls)
   {
      int gridItems = controls.size() * 2 + 1;

      statusBarGrid.resize(1, gridItems);

      statusBarGrid.getCellFormatter().setStyleName(0, 0, Style.STATUSBAR_SPACER);
      statusBarGrid.setHTML(0, 0, getSpacerImage());

      int i = 1;
      for (Control control : controls)
      {
         if (control instanceof StatusTextControl)
         {
            StatusBarTextControl textControl = new StatusBarTextControl(eventBus, (StatusTextControl)control);
            statusBarGrid.getCellFormatter().setStyleName(0, i, Style.STATUSBAR_ELEMENT);
            statusBarGrid.clearCell(0, i);
            statusBarGrid.setWidget(0, i, textControl);

            if (((StatusTextControl)control).getSize() < 0)
            {
               //DOM.setStyleAttribute(statusBarGrid.getCellFormatter().getElement(0, i), "width", "100%");
            }
            else
            {
               DOM.setStyleAttribute(statusBarGrid.getCellFormatter().getElement(0, i), "width", ""
                  + ((StatusTextControl)control).getSize() + "px");

               StatusBarTextControl c = (StatusBarTextControl)statusBarGrid.getWidget(0, i);
               if (c != null)
               {
                  c.setWidth("" + ((StatusTextControl)control).getSize() + "px");
               }

            }
         }
         else
         {
            StatusBarLoaderControl loaderControl = new StatusBarLoaderControl(eventBus, (LoaderControl)control);
            statusBarGrid.getCellFormatter().setStyleName(0, i, Style.STATUSBAR_ELEMENT);
            statusBarGrid.clearCell(0, i);
            statusBarGrid.setWidget(0, i, loaderControl);
            DOM.setStyleAttribute(statusBarGrid.getCellFormatter().getElement(0, i), "width", ""
               + loaderControl.getLoaderWidth() + "px");
         }

         i++;

         statusBarGrid.getCellFormatter().setStyleName(0, i, Style.STATUSBAR_SPACER);
         statusBarGrid.setHTML(0, i, getSpacerImage());

         i++;
      }
   }

   public String getSpacerImage()
   {
      return "<img src=\"" + ExoStyle.getEXoStyleURL() + "blank.gif" + "\" class=\"" + Style.STATUSBAR_SPACER + "\" />";
   }

}
