/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.statusbar;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.commons.component.Handlers;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.LoaderControl;
import org.exoplatform.gwtframework.ui.client.component.command.StatusTextControl;
import org.exoplatform.gwtframework.ui.client.component.statusbar.event.UpdateStatusBarEvent;
import org.exoplatform.gwtframework.ui.client.component.statusbar.event.UpdateStatusBarHandler;

import com.google.gwt.event.shared.HandlerManager;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class GWTStatusBarPresenter implements UpdateStatusBarHandler
{

   public interface Display
   {

      public void updateStatusBar(List<Control> items);

   }

   private Display display;

   private Handlers handlers;

   public GWTStatusBarPresenter(HandlerManager eventBus)
   {
      handlers = new Handlers(eventBus);
   }

   public void bindDisplay(Display d)
   {
      display = d;
      handlers.addHandler(UpdateStatusBarEvent.TYPE, this);
   }

   private Control getCommand(String commandId, List<Control> commands)
   {
      for (Control command : commands)
      {
         if (commandId.equals(command.getId()))
         {
            return command;
         }
      }

      return null;
   }

   /**
    * Refreshing state of status bar
    * 
    * @see org.exoplatform.gwtframework.ui.client.component.statusbar.event.UpdateStatusBarHandler#onRefreshStatusBar(org.exoplatform.gwtframework.ui.client.component.statusbar.event.UpdateStatusBarEvent)
    */
   public void onRefreshStatusBar(UpdateStatusBarEvent event)
   {
      List<Control> statusBarItems = new ArrayList<Control>();

      for (String id : event.getStatusBarItems())
      {
         Control command = getCommand(id, event.getCommands());
         if (command == null)
         {
            continue;
         }

         /*
          * accept only StatusText and Loader controls
          */
         if (!(command instanceof StatusTextControl ||
                  command instanceof LoaderControl))
         {
            continue;
         }

         statusBarItems.add(command);
      }

      display.updateStatusBar(statusBarItems);
   }

}
