/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.statusbar.component;

import org.exoplatform.gwtframework.ui.client.component.ExoStyle;
import org.exoplatform.gwtframework.ui.client.component.command.LoaderControl;
import org.exoplatform.gwtframework.ui.client.component.command.LoaderControlStateListener;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class StatusBarLoaderControl extends Composite implements LoaderControlStateListener
{

   public interface Style
   {

      static final String PANEL = "exo-statusBar-loader-panel";

      static final String PANEL_SINGLE = "exo-statusBar-loader-panel-single";

      static final String PANEL_HIDEN = "exo-statusBar-loader-panel-hidden";

      static final String TABLE = "exo-statusBar-loader-table";

      static final String TABLE_SINGLE = "exo-statusBar-loader-table-single";

      static final String TABLE_LEFT = "exo-statusBar-loader-table-left";

      static final String TABLE_STRETCH = "exo-statusBar-loader-table-stretch";

      static final String TABLE_DELIMITER = "exo-statusBar-loader-table-delimiter";

      static final String TABLE_BUTTON = "exo-statusBar-loader-table-button";

      static final String TABLE_RIGHT = "exo-statusBar-loader-table-right";

      static final String LOADER_IMAGE_PANEL = "exo-statusBar-loader-image-panel";

      static final String LOADER_IMAGE = "exo-statusBar-loader-image";

      static final String BUTTON_PANEL = "exo-statusBar-loader-button-panel";

      static final String BUTTON_ICON = "exo-statusBar-loader-button-icon";

   }

   private HandlerManager eventBus;

   private FlowPanel panel;

   private LoaderControl loaderControl;

   private Grid grid;

   private ButtonImage buttonIcon;

   private boolean hasIcon;

   private SimplePanel buttonPanel;

   public StatusBarLoaderControl(HandlerManager eventBus, LoaderControl command)
   {
      this.eventBus = eventBus;
      this.loaderControl = command;
      command.getStateListeners().add(this);

      hasIcon = command.getIcon() != null;
      if (command.getNormalImage() != null)
      {
         hasIcon = true;
      }

      panel = new FlowPanel();
      initWidget(panel);
      updateControlVisibility(command.isVisible());

      grid = new Grid(1, hasIcon ? 5 : 3);
      grid.setStyleName(hasIcon ? Style.TABLE : Style.TABLE_SINGLE);
      grid.setBorderWidth(0);
      grid.setCellPadding(0);
      grid.setCellSpacing(0);

      grid.setHTML(0, 0, ExoStyle.getBlankImage());

      SimplePanel simplePanel = new SimplePanel();
      simplePanel.setStyleName(Style.LOADER_IMAGE_PANEL);

      DOM.setInnerHTML(simplePanel.getElement(), getLoaderImage());
      grid.setWidget(0, 1, simplePanel);

      if (hasIcon)
      {
         grid.setHTML(0, 2, ExoStyle.getBlankImage());

         buttonPanel = new SimplePanel();
         buttonPanel.setStyleName(Style.BUTTON_PANEL);

         if (command.getNormalImage() != null)
         {
            buttonIcon = new ButtonImage(command.getNormalImage());
         }
         else
         {
            buttonIcon = new ButtonImage(command.getIcon());
         }

         buttonIcon.setStyleName(Style.BUTTON_ICON);
         buttonIcon.setTitle(command.getPrompt());
         buttonPanel.add(buttonIcon);

         grid.setWidget(0, 3, buttonPanel);

         grid.setHTML(0, 4, ExoStyle.getBlankImage());
      }
      else
      {
         grid.setHTML(0, 2, ExoStyle.getBlankImage());
      }

      panel.add(grid);

      setNormal();
   }

   public int getLoaderWidth()
   {
      if (hasIcon)
      {
         return 246;
      }
      else
      {
         return 222;
      }
   }

   private void setNormal()
   {
      if (hasIcon)
      {
         grid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT);
         grid.getCellFormatter().setStyleName(0, 1, Style.TABLE_STRETCH);
         grid.getCellFormatter().setStyleName(0, 2, Style.TABLE_DELIMITER);
         grid.getCellFormatter().setStyleName(0, 3, Style.TABLE_BUTTON);
         grid.getCellFormatter().setStyleName(0, 4, Style.TABLE_RIGHT);
      }
      else
      {
         grid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT);
         grid.getCellFormatter().setStyleName(0, 1, Style.TABLE_STRETCH);
         grid.getCellFormatter().setStyleName(0, 2, Style.TABLE_RIGHT);
      }
   }

   private void setOver()
   {
      if (hasIcon)
      {
         grid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT + "-over");
         grid.getCellFormatter().setStyleName(0, 1, Style.TABLE_STRETCH + "-over");
         grid.getCellFormatter().setStyleName(0, 2, Style.TABLE_DELIMITER + "-over");
         grid.getCellFormatter().setStyleName(0, 3, Style.TABLE_BUTTON + "-over");
         grid.getCellFormatter().setStyleName(0, 4, Style.TABLE_RIGHT + "-over");
      }
      else
      {
         grid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT + "-over");
         grid.getCellFormatter().setStyleName(0, 1, Style.TABLE_STRETCH + "-over");
         grid.getCellFormatter().setStyleName(0, 2, Style.TABLE_RIGHT + "-over");
      }
   }

   private void setDown()
   {
      if (hasIcon)
      {
         grid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT + "-down");
         grid.getCellFormatter().setStyleName(0, 1, Style.TABLE_STRETCH + "-down");
         grid.getCellFormatter().setStyleName(0, 2, Style.TABLE_DELIMITER + "-down");
         grid.getCellFormatter().setStyleName(0, 3, Style.TABLE_BUTTON + "-down");
         grid.getCellFormatter().setStyleName(0, 4, Style.TABLE_RIGHT + "-down");
      }
      else
      {
         grid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT + "-down");
         grid.getCellFormatter().setStyleName(0, 1, Style.TABLE_STRETCH + "-down");
         grid.getCellFormatter().setStyleName(0, 2, Style.TABLE_RIGHT + "-down");
      }
   }

   private String getLoaderImage()
   {
      String url =
         "<img src=\"" + ExoStyle.getEXoStyleURL() + "statusbar/loader/ajax-loader.gif" + "\" class=\""
            + Style.LOADER_IMAGE + "\" />";
      return url;
   }

   private void onMouseOver()
   {
      setOver();
   }

   private void onMouseOut()
   {
      setNormal();
   }

   private void onMouseDown()
   {
      setDown();
   }

   private void onMouseUp()
   {
      setOver();

      if (loaderControl.getEvent() != null)
      {
         eventBus.fireEvent(loaderControl.getEvent());
      }
   }

   private class ButtonImage extends Image
   {

      public ButtonImage(ImageResource imageResource)
      {
         super(imageResource);
         sinkEvents(Event.ONMOUSEOVER | Event.ONMOUSEOUT | Event.ONMOUSEDOWN | Event.ONMOUSEUP);
      }

      public ButtonImage(String url)
      {
         super(url);
         sinkEvents(Event.ONMOUSEOVER | Event.ONMOUSEOUT | Event.ONMOUSEDOWN | Event.ONMOUSEUP);
      }

      @Override
      public void onBrowserEvent(Event event)
      {
         if (!loaderControl.isEnabled())
         {
            return;
         }

         switch (DOM.eventGetType(event))
         {
            case Event.ONMOUSEOVER :
               onMouseOver();
               break;

            case Event.ONMOUSEOUT :
               onMouseOut();
               break;

            case Event.ONMOUSEDOWN :
               onMouseDown();
               break;

            case Event.ONMOUSEUP :
               onMouseUp();
               break;
         }
      }

   }

   public void updateControlEnabling(boolean enabled)
   {
   }

   public void updateControlIcon(String icon)
   {
      if (buttonPanel == null)
      {
         return;
      }

      if (loaderControl.getNormalImage() != null)
      {
         buttonIcon = new ButtonImage(loaderControl.getNormalImage());
      }
      else
      {
         buttonIcon = new ButtonImage(loaderControl.getIcon());
      }

      buttonIcon.setStyleName(Style.BUTTON_ICON);
      buttonIcon.setTitle(loaderControl.getPrompt());

      buttonPanel.clear();
      buttonPanel.add(buttonIcon);
   }

   public void updateControlPrompt(String prompt)
   {
   }

   public void updateControlVisibility(boolean visible)
   {
      if (visible)
      {
         if (hasIcon)
         {
            panel.setStyleName(Style.PANEL);
         }
         else
         {
            panel.setStyleName(Style.PANEL_SINGLE);
         }
      }
      else
      {
         panel.setStyleName(Style.PANEL_HIDEN);
      }
   }

}
