/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.toolbar.component;

import org.exoplatform.gwtframework.ui.client.component.ExoStyle;
import org.exoplatform.gwtframework.ui.client.component.toolbar.style.ToolbarDelimiterStyle;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarDelimiter extends Composite implements ToolbarControl
{

   private SimplePanel simplePanel;

   private boolean rightDocking;

   private boolean visible;

   public ToolbarDelimiter(boolean rightDocking)
   {
      this.rightDocking = rightDocking;

      simplePanel = new SimplePanel();
      initWidget(simplePanel);
      setVisible();
      DOM.setInnerHTML(simplePanel.getElement(), "<img src=\"" + ExoStyle.getEXoStyleURL() + "toolbar/delimeter.png"
         + "\" />");
   }

   public boolean isControlVisible()
   {
      return visible;
   }

   public void setVisible()
   {
      visible = true;
      simplePanel.setStyleName(rightDocking ? ToolbarDelimiterStyle.DELIMITER_RIGHT
         : ToolbarDelimiterStyle.DELIMITER_LEFT);
   }

   public void setHidden()
   {
      visible = false;
      simplePanel.setStyleName(rightDocking ? ToolbarDelimiterStyle.DELIMITER_RIGHT_HIDDEN
         : ToolbarDelimiterStyle.DELIMITER_LEFT_HIDDEN);
   }

}
