/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.showcase.cases;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.commons.component.Handlers;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.command.builder.SimpleCommandBuilder;
import org.exoplatform.gwtframework.ui.client.component.menu.GWTMenuBar;
import org.exoplatform.gwtframework.ui.client.component.menu.event.UpdateMainMenuEvent;
import org.exoplatform.gwtframework.ui.client.showcase.ShowCaseImages;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class MenuShowcase extends Composite
{

   private FlowPanel panel;

   private HandlerManager eventBus;

   private SimpleControl newXmlCommand;

   public MenuShowcase()
   {
      panel = new FlowPanel();
      initWidget(panel);

      //DOM.setStyleAttribute(panel.getElement(), "border", "#aaaaaa 1px solid");

      DOM.setStyleAttribute(panel.getElement(), "background", "#efefef");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");

      eventBus = new HandlerManager(null);
      new Handlers(eventBus);

      createMenu();
      fillMenu();
   }

   private void createMenu()
   {
      GWTMenuBar menu = new GWTMenuBar(eventBus);
      panel.add(menu);
   }
   
   private void fillMenu() 
   {
      newXmlCommand = SimpleCommandBuilder.newCommand("File/New/XML")
         .title("New Xml File")
         .prompt("Create new XML file")
         .icon(ShowCaseImages.XML)
         .enable()
         .show()
         .create();
      
      List<Control> commands = new ArrayList<Control>();
      commands.add(newXmlCommand);
      
      eventBus.fireEvent(new UpdateMainMenuEvent(commands));
      
   }

}
