/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.commons.component.Handlers;
import org.exoplatform.gwtframework.ui.client.ShowCaseImageBundle;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.command.TextInputControl;
import org.exoplatform.gwtframework.ui.client.component.command.builder.SimpleCommandBuilder;
import org.exoplatform.gwtframework.ui.client.component.command.builder.TextInputCommandBuilder;
import org.exoplatform.gwtframework.ui.client.component.toolbar.GWTToolbarForm;
import org.exoplatform.gwtframework.ui.client.component.toolbar.ToolbarItemType;
import org.exoplatform.gwtframework.ui.client.component.toolbar.event.UpdateToolbarEvent;
import org.exoplatform.gwtframework.ui.client.showcase.ShowCaseImages;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar_text_input.event.EnableDisableTextInputEvent;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar_text_input.event.EnableDisableTextInputHandler;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar_text_input.event.ShowHideTextInputEvent;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar_text_input.event.ShowHideTextInputHandler;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseTextEnteredEvent;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseTextEnteredHandler;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarTextInputShowcase extends Composite implements ShowcaseTextEnteredHandler, EnableDisableTextInputHandler, ShowHideTextInputHandler
{

   private FlowPanel panel;

   private GWTToolbarForm toolbar;

   private HandlerManager eventBus;

   private Handlers handlers;

   private SimpleControl enableDisableTextInputCommand1;

   private SimpleControl enableDisableTextInputCommand2;
   
   private SimpleControl showHideTextInputCommand1;
   
   private SimpleControl showHideTextInputCommand2;

   private TextInputControl textInputCommand1;

   private TextInputControl textInputCommand2;

   public ToolbarTextInputShowcase()
   {
      panel = new FlowPanel();
      initWidget(panel);

      DOM.setStyleAttribute(panel.getElement(), "border", "#aaaaaa 1px solid");

      DOM.setStyleAttribute(panel.getElement(), "background", "#efefef");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");

      eventBus = new HandlerManager(null);
      handlers = new Handlers(eventBus);

      handlers.addHandler(ShowcaseTextEnteredEvent.TYPE, this);
      handlers.addHandler(EnableDisableTextInputEvent.TYPE, this);
      handlers.addHandler(ShowHideTextInputEvent.TYPE, this);

      EnableDisableTextInputEvent event1 = new EnableDisableTextInputEvent(1);
      EnableDisableTextInputEvent event2 = new EnableDisableTextInputEvent(2);
      
      enableDisableTextInputCommand1 = SimpleCommandBuilder.newCommand("enable/disable1")
         .event(event1)
         .title("Disable left text input")
         .prompt("Disable left text input")
         //.icon(ShowCaseImages.CANCEL)
         .images(ShowCaseImageBundle.INSTANCE.cancel(), ShowCaseImageBundle.INSTANCE.cancelDisabled())
         .enable()
         .show()
         .create();
      
      enableDisableTextInputCommand2 = SimpleCommandBuilder.newCommand("enable/disable2")
         .event(event2)
         //.icon(ShowCaseImages.CANCEL)
         .images(ShowCaseImageBundle.INSTANCE.cancel(), ShowCaseImageBundle.INSTANCE.cancelDisabled())
         .title("Disable right text input")
         .prompt("Disable right text input")
         .enable()
         .show()
         .create();
      
      showHideTextInputCommand1 = SimpleCommandBuilder.newCommand("show/hide1")
         .prompt("Hide left text input")
         .title("Hide left text input")
         //.icon(ShowCaseImages.REMOVE)
         .images(ShowCaseImageBundle.INSTANCE.remove(), ShowCaseImageBundle.INSTANCE.removeDisabled())
         .event(new ShowHideTextInputEvent(1))
         .enable()
         .show()
         .create();

      showHideTextInputCommand2 = SimpleCommandBuilder.newCommand("show/hide2")
         .title("Hide right text input")
         .prompt("Hide right text input")
         //.icon(ShowCaseImages.REMOVE)
         .images(ShowCaseImageBundle.INSTANCE.remove(), ShowCaseImageBundle.INSTANCE.removeDisabled())
         .event(new ShowHideTextInputEvent(2))
         .show()
         .enable()
         .create();
      
      textInputCommand1 = TextInputCommandBuilder.newCommand("textinput1")
         .prompt("Do Search 1")
         //.icon(ShowCaseImages.SEARCH)
         .images(ShowCaseImageBundle.INSTANCE.search(), ShowCaseImageBundle.INSTANCE.searchDisabled())
         .enable()
         .show()
         .event(new ShowcaseTextEnteredEvent())
         .size(150)
         .create();
      
      textInputCommand2 = TextInputCommandBuilder.newCommand("textinput2")
         .prompt("Do Search 2")
         //.icon(ShowCaseImages.SEARCH)
         .images(ShowCaseImageBundle.INSTANCE.search(), ShowCaseImageBundle.INSTANCE.searchDisabled())
         .enable()
         .show()
         .event(new ShowcaseTextEnteredEvent())
         .size(200)
         .create();
      
      createToolbar();
   }

   private void createToolbar()
   {
      toolbar = new GWTToolbarForm(eventBus);
      panel.add(toolbar);

      List<Control> commands = new ArrayList<Control>();
      commands.add(enableDisableTextInputCommand1);
      commands.add(enableDisableTextInputCommand2);
      commands.add(showHideTextInputCommand1);
      commands.add(showHideTextInputCommand2);
      commands.add(textInputCommand1);
      commands.add(textInputCommand2);

      List<String> toolbarItems = new ArrayList<String>();
      toolbarItems.add(ToolbarItemType.DELIMITER);
      toolbarItems.add(enableDisableTextInputCommand1.getId());
      toolbarItems.add(showHideTextInputCommand1.getId());
      toolbarItems.add(ToolbarItemType.DELIMITER);
      toolbarItems.add(textInputCommand1.getId());
      toolbarItems.add(enableDisableTextInputCommand1.getId());

      toolbarItems.add(ToolbarItemType.SPACER);

      toolbarItems.add(textInputCommand2.getId());
      toolbarItems.add(ToolbarItemType.DELIMITER);
      toolbarItems.add(showHideTextInputCommand2.getId());
      toolbarItems.add(enableDisableTextInputCommand2.getId());
      toolbarItems.add(ToolbarItemType.DELIMITER);

      eventBus.fireEvent(new UpdateToolbarEvent(toolbarItems, commands));

   }

   public void onShowcaseTextEntered(ShowcaseTextEnteredEvent event)
   {
      Window.alert("Entered text [" + event.getText() + "]");
   }

   public void onEnableDisableTextInput(EnableDisableTextInputEvent event)
   {
      if (event.getTextInputId() == 1)
      {
         if (textInputCommand1.isEnabled())
         {
            /*
             * disabling text input 1
             */
            textInputCommand1.setEnabled(false);
            enableDisableTextInputCommand1.setPrompt("Enable left text input");
            textInputCommand1.setIcon(ShowCaseImages.CANCEL);
            enableDisableTextInputCommand1.setIcon(ShowCaseImages.OK);
         }
         else
         {
            textInputCommand1.setEnabled(true);
            enableDisableTextInputCommand1.setPrompt("Disable left text input");
            textInputCommand1.setIcon(ShowCaseImages.SEARCH);
            enableDisableTextInputCommand1.setIcon(ShowCaseImages.CANCEL);
         }
      }
      else
      {
         if (textInputCommand2.isEnabled())
         {
            textInputCommand2.setEnabled(false);
            enableDisableTextInputCommand2.setPrompt("Enable right text input");
            textInputCommand2.setIcon(ShowCaseImages.CANCEL);
            enableDisableTextInputCommand2.setIcon(ShowCaseImages.OK);
         }
         else
         {
            textInputCommand2.setEnabled(true);
            enableDisableTextInputCommand2.setPrompt("Disable right text input");
            textInputCommand2.setIcon(ShowCaseImages.SEARCH);
            enableDisableTextInputCommand2.setIcon(ShowCaseImages.CANCEL);
         }
      }

   }

   public void onShowHideTextInput(ShowHideTextInputEvent event)
   {
      if (event.getTextInputId() == 1)
      {
         if (textInputCommand1.isVisible())
         {
            textInputCommand1.setVisible(false);
            showHideTextInputCommand1.setIcon(ShowCaseImages.ADD);
            showHideTextInputCommand1.setPrompt("Show left text input");
         }
         else
         {
            textInputCommand1.setVisible(true);
            showHideTextInputCommand1.setIcon(ShowCaseImages.REMOVE);
            showHideTextInputCommand1.setPrompt("Hide left text input");
         }
      }
      else
      {
         if (textInputCommand2.isVisible())
         {
            textInputCommand2.setVisible(false);
            showHideTextInputCommand2.setIcon(ShowCaseImages.ADD);
            showHideTextInputCommand2.setPrompt("Show right text input");
         }
         else
         {
            textInputCommand2.setVisible(true);
            showHideTextInputCommand2.setIcon(ShowCaseImages.REMOVE);
            showHideTextInputCommand2.setPrompt("Hide right text input");
         }
      }
   }

}
